/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.handler.builtin;

import com.slack.api.app_backend.events.payload.EventsApiPayload;
import com.slack.api.bolt.context.builtin.EventContext;
import com.slack.api.bolt.handler.BoltEventHandler;
import com.slack.api.bolt.model.Bot;
import com.slack.api.bolt.model.Installer;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.InstallationService;
import com.slack.api.methods.SlackApiException;
import com.slack.api.model.event.TokensRevokedEvent;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTokensRevokedEventHandler
implements BoltEventHandler<TokensRevokedEvent> {
    private final InstallationService installationService;
    private final ExecutorService executorService;
    private final Logger logger = LoggerFactory.getLogger(DefaultTokensRevokedEventHandler.class);

    public static DefaultTokensRevokedEventHandler getInstance(InstallationService installationService, ExecutorService executorService) {
        return new DefaultTokensRevokedEventHandler(installationService, executorService);
    }

    public DefaultTokensRevokedEventHandler(InstallationService installationService, ExecutorService executorService) {
        this.installationService = installationService;
        this.executorService = executorService;
    }

    @Override
    public Response apply(EventsApiPayload<TokensRevokedEvent> payload, EventContext context) throws IOException, SlackApiException {
        String enterpriseId = payload.getEnterpriseId();
        String teamId = payload.getTeamId();
        this.executorService.submit(() -> {
            Bot bot;
            TokensRevokedEvent.Tokens tokens = ((TokensRevokedEvent)payload.getEvent()).getTokens();
            if (tokens.getOauth() != null) {
                for (String userId : tokens.getOauth()) {
                    Installer installer = this.installationService.findInstaller(enterpriseId, teamId, userId);
                    if (installer == null) continue;
                    try {
                        this.installationService.deleteInstaller(installer);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to delete an installation - enterprise_id: {}, team_id: {}, user_id: {}", new Object[]{enterpriseId, teamId, userId});
                    }
                }
            }
            if (tokens.getBot() != null && tokens.getBot().size() > 0 && (bot = this.installationService.findBot(enterpriseId, teamId)) != null) {
                try {
                    this.installationService.deleteBot(bot);
                }
                catch (Exception e) {
                    this.logger.error("Failed to delete a bot installation - enterprise_id: {}, team_id: {}", (Object)enterpriseId, (Object)teamId);
                }
            }
        });
        return context.ack();
    }
}

