/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.interactive_components.payload.AttachmentActionPayload;
import com.slack.api.bolt.context.builtin.AttachmentActionContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class AttachmentActionRequest
extends Request<AttachmentActionContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final AttachmentActionPayload payload;
    private AttachmentActionContext context = new AttachmentActionContext();

    public AttachmentActionRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (AttachmentActionPayload)GsonFactory.createSnakeCase().fromJson(payloadBody, AttachmentActionPayload.class);
        if (this.payload != null) {
            this.getContext().setResponseUrl(this.payload.getResponseUrl());
            if (this.payload.getEnterprise() != null) {
                this.getContext().setEnterpriseId(this.payload.getEnterprise().getId());
            } else if (this.payload.getTeam() != null) {
                this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
            }
            if (this.payload.getTeam() != null) {
                this.getContext().setTeamId(this.payload.getTeam().getId());
            }
            if (this.payload.getChannel() != null) {
                this.getContext().setChannelId(this.payload.getChannel().getId());
            }
            this.getContext().setRequestUserId(this.payload.getUser().getId());
        }
    }

    @Override
    public AttachmentActionContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.AttachmentAction;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getResponseUrl() {
        return this.getPayload() != null ? this.getPayload().getResponseUrl() : null;
    }

    public AttachmentActionPayload getPayload() {
        return this.payload;
    }

    @Override
    @Generated
    public String toString() {
        return "AttachmentActionRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

