/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.views.payload.ViewSubmissionPayload;
import com.slack.api.bolt.context.builtin.ViewSubmissionContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class ViewSubmissionRequest
extends Request<ViewSubmissionContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final ViewSubmissionPayload payload;
    private ViewSubmissionContext context = new ViewSubmissionContext();

    public ViewSubmissionRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (ViewSubmissionPayload)GsonFactory.createSnakeCase().fromJson(payloadBody, ViewSubmissionPayload.class);
        if (this.payload.getEnterprise() != null) {
            this.getContext().setEnterpriseId(this.payload.getEnterprise().getId());
        } else if (this.payload.getTeam() != null) {
            this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
        }
        if (this.payload.getView() != null && this.payload.getView().getAppInstalledTeamId() != null) {
            this.getContext().setTeamId(this.payload.getView().getAppInstalledTeamId());
        } else if (this.payload.getTeam() != null && this.payload.getTeam().getId() != null) {
            this.getContext().setTeamId(this.payload.getTeam().getId());
        } else if (this.payload.getView() != null && this.payload.getView().getTeamId() != null) {
            this.getContext().setTeamId(this.payload.getView().getTeamId());
        } else if (this.payload.getUser() != null && this.payload.getUser().getId() != null) {
            this.getContext().setTeamId(this.payload.getUser().getTeamId());
        }
        this.getContext().setRequestUserId(this.payload.getUser().getId());
        this.getContext().setResponseUrls(this.payload.getResponseUrls());
        this.getContext().setFunctionBotAccessToken(this.payload.getBotAccessToken());
        if (this.payload.getFunctionData() != null) {
            this.getContext().setFunctionExecutionId(this.payload.getFunctionData().getExecutionId());
        }
    }

    @Override
    public ViewSubmissionContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.ViewSubmission;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getResponseUrl() {
        if (this.payload.getResponseUrls() == null || this.payload.getResponseUrls().size() == 0) {
            return null;
        }
        int numOfResponseUrls = this.payload.getResponseUrls().size();
        if (numOfResponseUrls > 1) {
            String warnMessage = "You have " + numOfResponseUrls + " `response_url`s in the payload. ViewSubmissionRequest#getResponseUrl() always returns the first one.";
            this.getContext().getLogger().warn(warnMessage);
        }
        return ((ViewSubmissionPayload.ResponseUrl)this.payload.getResponseUrls().get(0)).getResponseUrl();
    }

    public ViewSubmissionPayload getPayload() {
        return this.payload;
    }

    @Override
    @Generated
    public String toString() {
        return "ViewSubmissionRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

