/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context;

import com.slack.api.Slack;
import com.slack.api.app_backend.views.InputBlockResponseSender;
import com.slack.api.app_backend.views.payload.ViewSubmissionPayload;
import com.slack.api.app_backend.views.response.InputBlockResponse;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;
import java.util.List;

public interface InputBlockRespondUtility {
    public Slack getSlack();

    public InputBlockResponseSender getResponder(String var1, String var2);

    public InputBlockResponseSender getFirstResponder();

    public List<ViewSubmissionPayload.ResponseUrl> getResponseUrls();

    default public WebhookResponse respond(String text) throws IOException {
        return this.respond(InputBlockResponse.builder().text(text).build());
    }

    default public WebhookResponse respond(List<LayoutBlock> blocks) throws IOException {
        return this.respond(InputBlockResponse.builder().blocks(blocks).build());
    }

    default public WebhookResponse respond(InputBlockResponse response) throws IOException {
        InputBlockResponseSender responder = this.getFirstResponder();
        if (responder == null) {
            throw new IllegalStateException("This payload doesn't have response_urls. The response_urls are available only when your modal has input block elements with response_url_enabled = true.");
        }
        return responder.send(response);
    }

    default public WebhookResponse respond(BuilderConfigurator<InputBlockResponse.InputBlockResponseBuilder> builder) throws IOException {
        return this.respond(builder.configure(InputBlockResponse.builder()).build());
    }
}

