/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.handler.builtin;

import com.slack.api.app_backend.events.payload.EventsApiPayload;
import com.slack.api.bolt.context.builtin.EventContext;
import com.slack.api.bolt.handler.BoltEventHandler;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.InstallationService;
import com.slack.api.methods.SlackApiException;
import com.slack.api.model.event.AppUninstalledEvent;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAppUninstalledEventHandler
implements BoltEventHandler<AppUninstalledEvent> {
    private final InstallationService installationService;
    private final ExecutorService executorService;
    private final Logger logger = LoggerFactory.getLogger(DefaultAppUninstalledEventHandler.class);

    public static DefaultAppUninstalledEventHandler getInstance(InstallationService installationService, ExecutorService executorService) {
        return new DefaultAppUninstalledEventHandler(installationService, executorService);
    }

    public DefaultAppUninstalledEventHandler(InstallationService installationService, ExecutorService executorService) {
        this.installationService = installationService;
        this.executorService = executorService;
    }

    @Override
    public Response apply(EventsApiPayload<AppUninstalledEvent> payload, EventContext context) throws IOException, SlackApiException {
        String enterpriseId = payload.getEnterpriseId();
        String teamId = payload.getTeamId();
        this.executorService.submit(() -> {
            try {
                this.installationService.deleteAll(enterpriseId, teamId);
                this.logger.info("Deleted all installation data for enterprise_id: {}, team_id: {}", (Object)enterpriseId, (Object)teamId);
            }
            catch (Exception e) {
                this.logger.error("Failed to delete all installation data for enterprise_id: {}, team_id: {}", new Object[]{enterpriseId, teamId, e});
            }
        });
        return context.ack();
    }
}

