/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.middleware.builtin;

import com.slack.api.bolt.middleware.Middleware;
import com.slack.api.bolt.middleware.MiddlewareChain;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.bolt.request.builtin.SSLCheckRequest;
import com.slack.api.bolt.response.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLCheck
implements Middleware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SSLCheck.class);
    private final String expectedVerificationToken;

    public SSLCheck(String verificationToken) {
        this.expectedVerificationToken = verificationToken;
    }

    @Override
    public Response apply(Request req, Response resp, MiddlewareChain chain) throws Exception {
        if (req.getRequestType() == RequestType.SSLCheck) {
            if (this.expectedVerificationToken != null) {
                SSLCheckRequest request = (SSLCheckRequest)req;
                String sslCheck = request.getPayload().getSslCheck();
                String actualVerificationToken = request.getPayload().getToken();
                if (!sslCheck.equals("1") || actualVerificationToken == null || !actualVerificationToken.equals(this.expectedVerificationToken)) {
                    log.info("Detected an invalid ssl_check request - payload: {}, headers: {}", (Object)request.getPayload(), (Object)request.getHeaders());
                    return Response.error(401);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Received a valid ssl_check request - payload: {}, headers: {}", (Object)request.getPayload(), (Object)request.getHeaders());
                }
            }
            return Response.ok();
        }
        return chain.next(req);
    }
}

