/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin.oauth.default_impl;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.context.builtin.OAuthCallbackContext;
import com.slack.api.bolt.model.builtin.DefaultInstaller;
import com.slack.api.bolt.request.builtin.OAuthCallbackRequest;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.InstallationService;
import com.slack.api.bolt.service.builtin.oauth.OAuthV2SuccessHandler;
import com.slack.api.bolt.service.builtin.oauth.view.OAuthRedirectUriPageRenderer;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.auth.AuthTestResponse;
import com.slack.api.methods.response.oauth.OAuthV2AccessResponse;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthV2DefaultSuccessHandler
implements OAuthV2SuccessHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuthV2DefaultSuccessHandler.class);
    private final AppConfig appConfig;
    private final InstallationService installationService;
    private final OAuthRedirectUriPageRenderer pageRenderer;

    public OAuthV2DefaultSuccessHandler(AppConfig appConfig, InstallationService installationService) {
        this.appConfig = appConfig;
        this.installationService = installationService;
        this.pageRenderer = appConfig.getOAuthRedirectUriPageRenderer();
    }

    @Override
    public Response handle(OAuthCallbackRequest request, Response response, OAuthV2AccessResponse o) {
        OAuthCallbackContext context = request.getContext();
        String enterpriseId = o.getEnterprise() != null ? o.getEnterprise().getId() : null;
        String enterpriseName = o.getEnterprise() != null ? o.getEnterprise().getName() : null;
        String teamId = o.getTeam() != null ? o.getTeam().getId() : null;
        String teamName = o.getTeam() != null ? o.getTeam().getName() : null;
        context.setEnterpriseId(enterpriseId);
        context.setTeamId(teamId);
        context.setBotUserId(o.getBotUserId());
        context.setBotToken(o.getAccessToken());
        context.setRequestUserId(o.getAuthedUser().getId());
        context.setRequestUserToken(o.getAccessToken());
        DefaultInstaller.DefaultInstallerBuilder i = DefaultInstaller.builder().appId(o.getAppId()).botUserId(o.getBotUserId()).botAccessToken(o.getAccessToken()).botRefreshToken(o.getRefreshToken()).botTokenExpiresAt(o.getExpiresIn() == null ? null : Long.valueOf(System.currentTimeMillis() + (long)(o.getExpiresIn() * 1000))).isEnterpriseInstall(o.isEnterpriseInstall()).tokenType(o.getTokenType()).enterpriseId(enterpriseId).enterpriseName(enterpriseName).teamId(teamId).teamName(teamName).scope(o.getScope()).botScope(o.getScope()).installedAt(System.currentTimeMillis());
        if (o.getAuthedUser() != null) {
            i = i.installerUserId(o.getAuthedUser().getId()).installerUserAccessToken(o.getAuthedUser().getAccessToken()).botRefreshToken(o.getAuthedUser().getRefreshToken()).botTokenExpiresAt(o.getAuthedUser().getExpiresIn() == null ? null : Long.valueOf(System.currentTimeMillis() + (long)(o.getAuthedUser().getExpiresIn() * 1000))).installerUserScope(o.getAuthedUser().getScope());
        }
        if (o.getBotUserId() != null) {
            try {
                AuthTestResponse authTest = context.client().authTest(r -> r);
                if (authTest.isOk()) {
                    i = i.botId(authTest.getBotId());
                    if (o.isEnterpriseInstall()) {
                        i = i.enterpriseUrl(authTest.getUrl());
                    }
                } else {
                    log.warn("Failed to call auth.test to fetch botId for the user: {} - {}", (Object)o.getBotUserId(), (Object)authTest.getError());
                }
            }
            catch (SlackApiException | IOException e) {
                log.warn("Failed to call auth.test to fetch botId for the user: {}", (Object)o.getBotUserId(), (Object)e);
            }
        }
        if (o.getIncomingWebhook() != null) {
            i = i.incomingWebhookChannelId(o.getIncomingWebhook().getChannelId()).incomingWebhookUrl(o.getIncomingWebhook().getUrl()).incomingWebhookConfigurationUrl(o.getIncomingWebhook().getConfigurationUrl());
        }
        DefaultInstaller installer = i.build();
        try {
            this.installationService.saveInstallerAndBot(installer);
            String url = context.getOauthCompletionUrl();
            if (url != null) {
                response.setStatusCode(302);
                response.getHeaders().put("Location", Arrays.asList(url));
            } else {
                response.setStatusCode(200);
                response.setBody(this.pageRenderer.renderSuccessPage(installer, this.appConfig.getOauthCompletionUrl()));
                response.setContentType("text/html; charset=utf-8");
            }
        }
        catch (Exception e) {
            log.warn("Failed to store the installation - {}", (Object)e.getMessage(), (Object)e);
            String url = context.getOauthCancellationUrl();
            if (url != null) {
                response.setStatusCode(302);
                response.getHeaders().put("Location", Arrays.asList(url));
            }
            String reason = e.getMessage();
            response.setStatusCode(200);
            response.setBody(this.pageRenderer.renderFailurePage(this.appConfig.getOauthInstallRequestURI(), reason));
            response.setContentType("text/html; charset=utf-8");
        }
        return response;
    }
}

