/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.response;

import com.slack.api.RequestConfigurator;
import com.slack.api.Slack;
import com.slack.api.app_backend.interactive_components.ActionResponseSender;
import com.slack.api.app_backend.interactive_components.response.ActionResponse;
import com.slack.api.app_backend.slash_commands.SlashCommandResponseSender;
import com.slack.api.app_backend.slash_commands.response.SlashCommandResponse;
import com.slack.api.util.http.SlackHttpClient;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;
import okhttp3.Response;

public class Responder {
    private final Slack slack;
    private final String responseUrl;
    private final ActionResponseSender actionResponseSender;
    private final SlashCommandResponseSender slashCommandResponseSender;

    public Responder(Slack slack, String responseUrl) {
        this.slack = slack;
        this.responseUrl = responseUrl;
        this.actionResponseSender = new ActionResponseSender(slack);
        this.slashCommandResponseSender = new SlashCommandResponseSender(slack);
    }

    public WebhookResponse send(SlashCommandResponse response) throws IOException {
        return new SlashCommandResponseSender(this.slack).send(this.responseUrl, response);
    }

    public WebhookResponse send(ActionResponse response) throws IOException {
        return new ActionResponseSender(this.slack).send(this.responseUrl, response);
    }

    public WebhookResponse send(com.slack.api.app_backend.outgoing_webhooks.response.WebhookResponse response) throws IOException {
        SlackHttpClient httpClient = this.slack.getHttpClient();
        Response httpResponse = httpClient.postJsonBody(this.responseUrl, (Object)response);
        String body = httpResponse.body().string();
        httpClient.runHttpResponseListeners(httpResponse, body);
        return WebhookResponse.builder().code(Integer.valueOf(httpResponse.code())).message(httpResponse.message()).body(body).build();
    }

    public WebhookResponse sendToAction(RequestConfigurator<ActionResponse.ActionResponseBuilder> body) throws IOException {
        return this.send(((ActionResponse.ActionResponseBuilder)body.configure((Object)ActionResponse.builder())).build());
    }

    public WebhookResponse sendToCommand(RequestConfigurator<SlashCommandResponse.SlashCommandResponseBuilder> body) throws IOException {
        return this.send(((SlashCommandResponse.SlashCommandResponseBuilder)body.configure((Object)SlashCommandResponse.builder())).build());
    }
}

