/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.middleware.builtin;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slack.api.SlackConfig;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.middleware.Middleware;
import com.slack.api.bolt.middleware.MiddlewareChain;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.bolt.request.builtin.EventRequest;
import com.slack.api.bolt.response.Response;
import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.bots.BotsInfoResponse;
import com.slack.api.util.json.GsonFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoringSelfEvents
implements Middleware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IgnoringSelfEvents.class);
    private final Gson gson;
    private final ConcurrentMap<String, String> botIdToBotUserId = new ConcurrentHashMap<String, String>();
    private List<String> eventTypesNotToMiss = new ArrayList<String>();

    public IgnoringSelfEvents(SlackConfig config) {
        this.eventTypesNotToMiss.add("member_joined_channel");
        this.eventTypesNotToMiss.add("member_left_channel");
        this.gson = GsonFactory.createSnakeCase((SlackConfig)config);
    }

    protected ConcurrentMap<String, String> getBotIdToBotUserId() {
        return this.botIdToBotUserId;
    }

    public List<String> getEventTypesNotToMiss() {
        return this.eventTypesNotToMiss;
    }

    public void setEventTypesNotToMiss(List<String> eventTypesNotToMiss) {
        this.eventTypesNotToMiss = eventTypesNotToMiss;
    }

    @Override
    public Response apply(Request req, Response resp, MiddlewareChain chain) throws Exception {
        if (req.getRequestType() == RequestType.Event) {
            String appBotUserId = ((Context)req.getContext()).getBotUserId();
            if (appBotUserId == null) {
                return chain.next(req);
            }
            EventRequest eventRequest = (EventRequest)req;
            String eventType = eventRequest.getEventType();
            if (eventType == null || this.eventTypesNotToMiss.contains(eventType)) {
                return chain.next(req);
            }
            JsonObject eventElem = this.extractEventElem(eventRequest.getRequestBodyAsString());
            if (eventElem != null) {
                JsonElement eventUserIdElem = eventElem.get("user");
                String eventBotUserId = eventUserIdElem != null ? eventUserIdElem.getAsString() : null;
                JsonElement botIdElem = eventElem.get("bot_id");
                if (eventBotUserId == null && botIdElem != null) {
                    String botId = botIdElem.getAsString();
                    eventBotUserId = this.findAndSaveBotUserId(((Context)req.getContext()).client(), botId);
                }
                if (eventBotUserId != null && eventBotUserId.equals(appBotUserId)) {
                    log.debug("Skipped the event (type: {}) as it was generated by this app's bot user", (Object)eventType);
                    return resp;
                }
            }
        }
        return chain.next(req);
    }

    private JsonObject extractEventElem(String requestBody) {
        JsonElement payload = (JsonElement)this.gson.fromJson(requestBody, JsonElement.class);
        return payload.getAsJsonObject().getAsJsonObject("event");
    }

    protected String findAndSaveBotUserId(MethodsClient client, String botId) throws IOException, SlackApiException {
        String botUserId = (String)this.getBotIdToBotUserId().get(botId);
        if (botUserId != null) {
            return botUserId;
        }
        BotsInfoResponse botInfo = client.botsInfo(r -> r.bot(botId));
        if (botInfo.isOk()) {
            botUserId = botInfo.getBot().getUserId();
            if (botUserId != null) {
                this.getBotIdToBotUserId().put(botId, botUserId);
            }
            return botUserId;
        }
        return null;
    }
}

