/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.app_backend.slash_commands.response.SlashCommandResponse;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.context.SayUtility;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.response.ResponseUrlSender;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;
import java.util.List;

public class SlashCommandContext
extends Context
implements SayUtility {
    private String triggerId;
    private String channelId;
    private String responseUrl;
    private ResponseUrlSender responseUrlSender;

    public WebhookResponse respond(String text) throws IOException {
        return this.respond(SlashCommandResponse.builder().text(text).build());
    }

    public WebhookResponse respond(List<LayoutBlock> blocks) throws IOException {
        return this.respond(SlashCommandResponse.builder().blocks(blocks).build());
    }

    public WebhookResponse respond(SlashCommandResponse response) throws IOException {
        if (this.responseUrlSender == null) {
            this.responseUrlSender = new ResponseUrlSender(this.slack, this.responseUrl);
        }
        return this.responseUrlSender.send(response);
    }

    public WebhookResponse respond(BuilderConfigurator<SlashCommandResponse.SlashCommandResponseBuilder> builder) throws IOException {
        return this.respond(builder.configure(SlashCommandResponse.builder()).build());
    }

    public Response ack(String text) {
        return Response.json(200, SlashCommandResponse.builder().text(text).build());
    }

    public Response ack(List<LayoutBlock> blocks) {
        return Response.json(200, SlashCommandResponse.builder().blocks(blocks).build());
    }

    public Response ack(SlashCommandResponse response) {
        return Response.json(200, response);
    }

    public Response ack(BuilderConfigurator<SlashCommandResponse.SlashCommandResponseBuilder> builder) {
        return this.ack(builder.configure(SlashCommandResponse.builder()).build());
    }

    public static SlashCommandContextBuilder builder() {
        return new SlashCommandContextBuilder();
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    public String getResponseUrl() {
        return this.responseUrl;
    }

    public ResponseUrlSender getResponseUrlSender() {
        return this.responseUrlSender;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setResponseUrl(String responseUrl) {
        this.responseUrl = responseUrl;
    }

    public void setResponseUrlSender(ResponseUrlSender responseUrlSender) {
        this.responseUrlSender = responseUrlSender;
    }

    public SlashCommandContext() {
    }

    public SlashCommandContext(String triggerId, String channelId, String responseUrl, ResponseUrlSender responseUrlSender) {
        this.triggerId = triggerId;
        this.channelId = channelId;
        this.responseUrl = responseUrl;
        this.responseUrlSender = responseUrlSender;
    }

    @Override
    public String toString() {
        return "SlashCommandContext(super=" + super.toString() + ", triggerId=" + this.getTriggerId() + ", channelId=" + this.getChannelId() + ", responseUrl=" + this.getResponseUrl() + ", responseUrlSender=" + this.getResponseUrlSender() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlashCommandContext)) {
            return false;
        }
        SlashCommandContext other = (SlashCommandContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$triggerId = this.getTriggerId();
        String other$triggerId = other.getTriggerId();
        if (this$triggerId == null ? other$triggerId != null : !this$triggerId.equals(other$triggerId)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        String this$responseUrl = this.getResponseUrl();
        String other$responseUrl = other.getResponseUrl();
        if (this$responseUrl == null ? other$responseUrl != null : !this$responseUrl.equals(other$responseUrl)) {
            return false;
        }
        ResponseUrlSender this$responseUrlSender = this.getResponseUrlSender();
        ResponseUrlSender other$responseUrlSender = other.getResponseUrlSender();
        return !(this$responseUrlSender == null ? other$responseUrlSender != null : !this$responseUrlSender.equals(other$responseUrlSender));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlashCommandContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $triggerId = this.getTriggerId();
        result = result * 59 + ($triggerId == null ? 43 : $triggerId.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        String $responseUrl = this.getResponseUrl();
        result = result * 59 + ($responseUrl == null ? 43 : $responseUrl.hashCode());
        ResponseUrlSender $responseUrlSender = this.getResponseUrlSender();
        result = result * 59 + ($responseUrlSender == null ? 43 : $responseUrlSender.hashCode());
        return result;
    }

    public static class SlashCommandContextBuilder {
        private String triggerId;
        private String channelId;
        private String responseUrl;
        private ResponseUrlSender responseUrlSender;

        SlashCommandContextBuilder() {
        }

        public SlashCommandContextBuilder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        public SlashCommandContextBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public SlashCommandContextBuilder responseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
            return this;
        }

        public SlashCommandContextBuilder responseUrlSender(ResponseUrlSender responseUrlSender) {
            this.responseUrlSender = responseUrlSender;
            return this;
        }

        public SlashCommandContext build() {
            return new SlashCommandContext(this.triggerId, this.channelId, this.responseUrl, this.responseUrlSender);
        }

        public String toString() {
            return "SlashCommandContext.SlashCommandContextBuilder(triggerId=" + this.triggerId + ", channelId=" + this.channelId + ", responseUrl=" + this.responseUrl + ", responseUrlSender=" + this.responseUrlSender + ")";
        }
    }
}

