/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.app_backend.interactive_components.response.ActionResponse;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.response.ResponseUrlSender;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;
import java.util.List;

public class ActionContext
extends Context {
    private String triggerId;
    private String responseUrl;
    private ResponseUrlSender responseUrlSender;

    public WebhookResponse respond(String text) throws IOException {
        return this.respond(ActionResponse.builder().text(text).build());
    }

    public WebhookResponse respond(List<LayoutBlock> blocks) throws IOException {
        return this.respond(ActionResponse.builder().blocks(blocks).build());
    }

    public WebhookResponse respond(ActionResponse response) throws IOException {
        if (this.responseUrlSender == null) {
            this.responseUrlSender = new ResponseUrlSender(this.slack, this.responseUrl);
        }
        return new ResponseUrlSender(this.slack, this.responseUrl).send(response);
    }

    public WebhookResponse respond(BuilderConfigurator<ActionResponse.ActionResponseBuilder> builder) throws IOException {
        return this.respond(builder.configure(ActionResponse.builder()).build());
    }

    public static ActionContextBuilder builder() {
        return new ActionContextBuilder();
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public String getResponseUrl() {
        return this.responseUrl;
    }

    public ResponseUrlSender getResponseUrlSender() {
        return this.responseUrlSender;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public void setResponseUrl(String responseUrl) {
        this.responseUrl = responseUrl;
    }

    public void setResponseUrlSender(ResponseUrlSender responseUrlSender) {
        this.responseUrlSender = responseUrlSender;
    }

    public ActionContext() {
    }

    public ActionContext(String triggerId, String responseUrl, ResponseUrlSender responseUrlSender) {
        this.triggerId = triggerId;
        this.responseUrl = responseUrl;
        this.responseUrlSender = responseUrlSender;
    }

    @Override
    public String toString() {
        return "ActionContext(super=" + super.toString() + ", triggerId=" + this.getTriggerId() + ", responseUrl=" + this.getResponseUrl() + ", responseUrlSender=" + this.getResponseUrlSender() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionContext)) {
            return false;
        }
        ActionContext other = (ActionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$triggerId = this.getTriggerId();
        String other$triggerId = other.getTriggerId();
        if (this$triggerId == null ? other$triggerId != null : !this$triggerId.equals(other$triggerId)) {
            return false;
        }
        String this$responseUrl = this.getResponseUrl();
        String other$responseUrl = other.getResponseUrl();
        if (this$responseUrl == null ? other$responseUrl != null : !this$responseUrl.equals(other$responseUrl)) {
            return false;
        }
        ResponseUrlSender this$responseUrlSender = this.getResponseUrlSender();
        ResponseUrlSender other$responseUrlSender = other.getResponseUrlSender();
        return !(this$responseUrlSender == null ? other$responseUrlSender != null : !this$responseUrlSender.equals(other$responseUrlSender));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActionContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $triggerId = this.getTriggerId();
        result = result * 59 + ($triggerId == null ? 43 : $triggerId.hashCode());
        String $responseUrl = this.getResponseUrl();
        result = result * 59 + ($responseUrl == null ? 43 : $responseUrl.hashCode());
        ResponseUrlSender $responseUrlSender = this.getResponseUrlSender();
        result = result * 59 + ($responseUrlSender == null ? 43 : $responseUrlSender.hashCode());
        return result;
    }

    public static class ActionContextBuilder {
        private String triggerId;
        private String responseUrl;
        private ResponseUrlSender responseUrlSender;

        ActionContextBuilder() {
        }

        public ActionContextBuilder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        public ActionContextBuilder responseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
            return this;
        }

        public ActionContextBuilder responseUrlSender(ResponseUrlSender responseUrlSender) {
            this.responseUrlSender = responseUrlSender;
            return this;
        }

        public ActionContext build() {
            return new ActionContext(this.triggerId, this.responseUrl, this.responseUrlSender);
        }

        public String toString() {
            return "ActionContext.ActionContextBuilder(triggerId=" + this.triggerId + ", responseUrl=" + this.responseUrl + ", responseUrlSender=" + this.responseUrlSender + ")";
        }
    }
}

