/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service;

import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface OAuthStateService {
    public static final long DEFAULT_EXPIRATION_IN_SECONDS = 600L;

    default public String getSessionCookieName() {
        return "slack-app-oauth-state";
    }

    default public String extractStateFromQueryString(Request request) {
        Map<String, List<String>> queryString = request.getQueryString();
        for (String key : queryString.keySet()) {
            List<String> values;
            if (!key.equals("state") || (values = queryString.get(key)) == null || values.size() <= 0) continue;
            return values.get(0);
        }
        return null;
    }

    default public String issueNewState(Request request, Response response) throws Exception {
        String newState = this.generateNewStateValue();
        String headerValue = this.getSessionCookieName() + "=" + this.generateSessionCookieValue(request, newState);
        headerValue = headerValue + "; Secure; HttpOnly; Path=/; Max-Age=" + this.getExpirationInSeconds();
        response.getHeaders().put("Set-Cookie", Arrays.asList(headerValue));
        this.addNewStateToDatastore(newState);
        return newState;
    }

    default public String generateNewStateValue() {
        return UUID.randomUUID().toString();
    }

    default public long getExpirationInSeconds() {
        return 600L;
    }

    default public String generateSessionCookieValue(Request request, String state) throws Exception {
        return state;
    }

    public void addNewStateToDatastore(String var1) throws Exception;

    default public boolean isValid(Request request) {
        String givenState = this.extractStateFromQueryString(request);
        if (givenState == null || givenState.trim().isEmpty()) {
            return false;
        }
        String stateInSession = this.extractStateFromSession(request);
        if (stateInSession == null || stateInSession.trim().isEmpty()) {
            return false;
        }
        if (!stateInSession.equals(givenState)) {
            return false;
        }
        return this.isAvailableInDatabase(givenState);
    }

    default public String extractStateFromSession(Request request) {
        List<String> cookieHeaders = request.getHeaders().getMultipleValues("Cookie");
        for (String header : cookieHeaders) {
            String[] valueWithAttributes;
            if (!header.startsWith(this.getSessionCookieName() + "=") || (valueWithAttributes = header.split(this.getSessionCookieName() + "=")) == null || valueWithAttributes.length <= 1) continue;
            String value = valueWithAttributes[1].split(";")[0];
            return value;
        }
        return null;
    }

    public boolean isAvailableInDatabase(String var1);

    default public void consume(Request request, Response response) throws Exception {
        String givenState = this.extractStateFromQueryString(request);
        List<String> setCookieHeaderValues = response.getHeaders().get("Set-Cookie");
        if (setCookieHeaderValues == null) {
            setCookieHeaderValues = new ArrayList<String>();
        }
        setCookieHeaderValues.add(this.getSessionCookieName() + "=deleted; Secure; HttpOnly; Path=/; Expires=Thu, 01 Jan 1970 00:00:00 GMT");
        response.getHeaders().put("Set-Cookie", setCookieHeaderValues);
        this.deleteStateFromDatastore(givenState);
    }

    public void deleteStateFromDatastore(String var1) throws Exception;
}

