/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.middleware.builtin;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.middleware.Middleware;
import com.slack.api.bolt.middleware.MiddlewareChain;
import com.slack.api.bolt.middleware.MiddlewareOps;
import com.slack.api.bolt.model.Bot;
import com.slack.api.bolt.model.Installer;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.InstallationService;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.auth.AuthTestResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTeamsAuthorization
implements Middleware {
    private static final Logger log = LoggerFactory.getLogger(MultiTeamsAuthorization.class);
    private final InstallationService installationService;
    private boolean alwaysRequestUserTokenNeeded;

    public boolean isAlwaysRequestUserTokenNeeded() {
        return this.alwaysRequestUserTokenNeeded;
    }

    public void setAlwaysRequestUserTokenNeeded(boolean alwaysRequestUserTokenNeeded) {
        this.alwaysRequestUserTokenNeeded = alwaysRequestUserTokenNeeded;
    }

    public MultiTeamsAuthorization(AppConfig config, InstallationService installationService) {
        this.setAlwaysRequestUserTokenNeeded(config.isAlwaysRequestUserTokenNeeded());
        this.installationService = installationService;
    }

    @Override
    public Response apply(Request req, Response resp, MiddlewareChain chain) throws Exception {
        if (MiddlewareOps.isNoAuthRequiredRequest(req.getRequestType())) {
            return chain.next(req);
        }
        Object context = req.getContext();
        String botToken = null;
        String userToken = null;
        Bot bot = this.installationService.findBot(((Context)context).getEnterpriseId(), ((Context)context).getTeamId());
        Installer installer = null;
        if (bot != null) {
            botToken = bot.getBotAccessToken();
        }
        if ((this.isAlwaysRequestUserTokenNeeded() || bot == null) && ((Context)context).getRequestUserId() != null && (installer = this.installationService.findInstaller(((Context)context).getEnterpriseId(), ((Context)context).getTeamId(), ((Context)context).getRequestUserId())) != null) {
            userToken = installer.getInstallerUserAccessToken();
        }
        if (botToken == null && userToken == null) {
            return this.buildError(401, null, null, null);
        }
        try {
            String token = botToken != null ? botToken : userToken;
            AuthTestResponse authTestResponse = ((Context)context).client().authTest(r -> r.token(token));
            if (authTestResponse.isOk()) {
                ((Context)context).setBotToken(botToken);
                ((Context)context).setRequestUserToken(userToken);
                ((Context)context).setTeamId(authTestResponse.getTeamId());
                ((Context)context).setEnterpriseId(authTestResponse.getEnterpriseId());
                if (bot != null) {
                    ((Context)context).setBotId(bot.getBotId());
                    ((Context)context).setBotUserId(authTestResponse.getUserId());
                }
                return chain.next(req);
            }
            return this.handleAuthTestError(authTestResponse.getError(), bot, installer, authTestResponse);
        }
        catch (IOException e) {
            return this.buildError(503, null, e, null);
        }
        catch (SlackApiException e) {
            return this.buildError(503, null, null, e);
        }
    }

    protected Response handleAuthTestError(String errorCode, Bot foundBot, Installer foundInstaller, AuthTestResponse authTestResponse) throws Exception {
        if (errorCode.equals("account_inactive")) {
            if (foundBot != null) {
                this.installationService.deleteBot(foundBot);
            } else if (foundInstaller != null) {
                this.installationService.deleteInstaller(foundInstaller);
            }
        }
        return this.buildError(401, authTestResponse, null, null);
    }

    protected Response buildError(int statusCode, AuthTestResponse authTestResponse, IOException ioException, SlackApiException slackException) {
        log.info("auth.test result: {}, io error: {}, api error: {}", new Object[]{authTestResponse, ioException, slackException});
        return Response.builder().statusCode(statusCode).contentType("application/json").body("{\"error\":\"a request for an unknown workspace detected\"}").build();
    }
}

