/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.app_backend.interactive_components.response.ActionResponse;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.context.SayUtility;
import com.slack.api.bolt.response.ResponseUrlSender;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;

public class MessageActionContext
extends Context
implements SayUtility {
    private String triggerId;
    private String channelId;
    private String responseUrl;
    private ResponseUrlSender responseUrlSender;

    public WebhookResponse respond(ActionResponse response) throws IOException {
        if (this.responseUrlSender == null) {
            this.responseUrlSender = new ResponseUrlSender(this.slack, this.responseUrl);
        }
        return new ResponseUrlSender(this.slack, this.responseUrl).send(response);
    }

    public WebhookResponse respond(BuilderConfigurator<ActionResponse.ActionResponseBuilder> builder) throws IOException {
        return this.respond(builder.configure(ActionResponse.builder()).build());
    }

    public static MessageActionContextBuilder builder() {
        return new MessageActionContextBuilder();
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    public String getResponseUrl() {
        return this.responseUrl;
    }

    public ResponseUrlSender getResponseUrlSender() {
        return this.responseUrlSender;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setResponseUrl(String responseUrl) {
        this.responseUrl = responseUrl;
    }

    public void setResponseUrlSender(ResponseUrlSender responseUrlSender) {
        this.responseUrlSender = responseUrlSender;
    }

    public MessageActionContext() {
    }

    public MessageActionContext(String triggerId, String channelId, String responseUrl, ResponseUrlSender responseUrlSender) {
        this.triggerId = triggerId;
        this.channelId = channelId;
        this.responseUrl = responseUrl;
        this.responseUrlSender = responseUrlSender;
    }

    @Override
    public String toString() {
        return "MessageActionContext(super=" + super.toString() + ", triggerId=" + this.getTriggerId() + ", channelId=" + this.getChannelId() + ", responseUrl=" + this.getResponseUrl() + ", responseUrlSender=" + this.getResponseUrlSender() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageActionContext)) {
            return false;
        }
        MessageActionContext other = (MessageActionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$triggerId = this.getTriggerId();
        String other$triggerId = other.getTriggerId();
        if (this$triggerId == null ? other$triggerId != null : !this$triggerId.equals(other$triggerId)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        String this$responseUrl = this.getResponseUrl();
        String other$responseUrl = other.getResponseUrl();
        if (this$responseUrl == null ? other$responseUrl != null : !this$responseUrl.equals(other$responseUrl)) {
            return false;
        }
        ResponseUrlSender this$responseUrlSender = this.getResponseUrlSender();
        ResponseUrlSender other$responseUrlSender = other.getResponseUrlSender();
        return !(this$responseUrlSender == null ? other$responseUrlSender != null : !this$responseUrlSender.equals(other$responseUrlSender));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageActionContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $triggerId = this.getTriggerId();
        result = result * 59 + ($triggerId == null ? 43 : $triggerId.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        String $responseUrl = this.getResponseUrl();
        result = result * 59 + ($responseUrl == null ? 43 : $responseUrl.hashCode());
        ResponseUrlSender $responseUrlSender = this.getResponseUrlSender();
        result = result * 59 + ($responseUrlSender == null ? 43 : $responseUrlSender.hashCode());
        return result;
    }

    public static class MessageActionContextBuilder {
        private String triggerId;
        private String channelId;
        private String responseUrl;
        private ResponseUrlSender responseUrlSender;

        MessageActionContextBuilder() {
        }

        public MessageActionContextBuilder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        public MessageActionContextBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public MessageActionContextBuilder responseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
            return this;
        }

        public MessageActionContextBuilder responseUrlSender(ResponseUrlSender responseUrlSender) {
            this.responseUrlSender = responseUrlSender;
            return this;
        }

        public MessageActionContext build() {
            return new MessageActionContext(this.triggerId, this.channelId, this.responseUrl, this.responseUrlSender);
        }

        public String toString() {
            return "MessageActionContext.MessageActionContextBuilder(triggerId=" + this.triggerId + ", channelId=" + this.channelId + ", responseUrl=" + this.responseUrl + ", responseUrlSender=" + this.responseUrlSender + ")";
        }
    }
}

