/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.servlet;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.servlet.ServletAdapterOps;
import com.slack.api.bolt.util.QueryStringParser;
import com.slack.api.bolt.util.SlackRequestParser;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackAppServletAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackAppServletAdapter.class);
    private SlackRequestParser requestParser;

    public SlackAppServletAdapter(AppConfig appConfig) {
        this.requestParser = new SlackRequestParser(appConfig);
    }

    public Request<?> buildSlackRequest(HttpServletRequest req) throws IOException {
        String requestBody = this.doReadRequestBodyAsString(req);
        RequestHeaders headers = new RequestHeaders(ServletAdapterOps.toHeaderMap(req));
        SlackRequestParser.HttpRequest rawRequest = SlackRequestParser.HttpRequest.builder().requestUri(req.getRequestURI()).queryString(QueryStringParser.toMap((String)req.getQueryString())).headers(headers).requestBody(requestBody).remoteAddress(req.getRemoteAddr()).build();
        return this.requestParser.parse(rawRequest);
    }

    protected String doReadRequestBodyAsString(HttpServletRequest req) throws IOException {
        return ServletAdapterOps.doReadRequestBodyAsString(req);
    }

    public void writeResponse(HttpServletResponse resp, Response slackResp) throws IOException {
        ServletAdapterOps.writeResponse(resp, slackResp);
    }
}

