/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.micronaut;

import com.slack.api.bolt.App;
import com.slack.api.bolt.micronaut.SlackAppMicronautAdapter;
import com.slack.api.bolt.request.Request;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;

@Controller(value="/slack")
public class SlackAppController {
    private final App slackApp;
    private final SlackAppMicronautAdapter adapter;

    public SlackAppController(App slackApp, SlackAppMicronautAdapter adapter) {
        this.slackApp = slackApp;
        this.adapter = adapter;
    }

    @Post(value="/events", consumes={"application/x-www-form-urlencoded", "application/json"})
    public HttpResponse<String> events(HttpRequest<String> request, @Body String body) throws Exception {
        return this.adapt(request, body);
    }

    @Get(value="/install")
    public HttpResponse<String> install(HttpRequest<String> request) throws Exception {
        if (!this.slackApp.config().isOAuthInstallPathEnabled()) {
            return HttpResponse.notFound();
        }
        return this.adapt(request, null);
    }

    @Get(value="/oauth_redirect")
    public HttpResponse<String> oauthRedirect(HttpRequest<String> request) throws Exception {
        if (!this.slackApp.config().isOAuthRedirectUriPathEnabled()) {
            return HttpResponse.notFound();
        }
        return this.adapt(request, null);
    }

    private HttpResponse<String> adapt(HttpRequest<String> request, String body) throws Exception {
        Request<?> slackRequest = this.adapter.toSlackRequest(request, body);
        return this.adapter.toMicronautResponse(this.slackApp.run(slackRequest));
    }
}

