/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.http4k;

import com.slack.api.bolt.App;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.util.SlackRequestParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import org.http4k.core.Method;
import org.http4k.core.ParametersKt;
import org.http4k.core.Request;
import org.http4k.core.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http4kSlackApp
implements Function1<Request, org.http4k.core.Response> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Http4kSlackApp.class);
    protected final App app;
    protected final String path;
    protected final SlackRequestParser requestParser;

    public Http4kSlackApp(App app) {
        this(app, "/slack/events");
    }

    public Http4kSlackApp(App app, String path) {
        this.app = app;
        this.path = path;
        this.requestParser = new SlackRequestParser(app.config());
    }

    public org.http4k.core.Response invoke(Request request) {
        Method requestMethod = request.getMethod();
        String requestPath = request.getUri().getPath();
        if (requestMethod == null) {
            return this.notFound(request);
        }
        if (requestMethod == Method.POST && requestPath.equals(this.getSlackEventsRequestURI())) {
            return this.handleEventRequest(request);
        }
        if (requestMethod == Method.GET) {
            if (this.app.config().isOAuthInstallPathEnabled() && requestPath.equals(this.app.config().getOauthInstallRequestURI())) {
                return this.handleOAuthRequest(request);
            }
            if (this.app.config().isOAuthInstallPathEnabled() && requestPath.equals(this.app.config().getOauthRedirectUriRequestURI())) {
                return this.handleOAuthRequest(request);
            }
        }
        return this.notFound(request);
    }

    protected String getSlackEventsRequestURI() {
        if (this.app.config().getAppPath() != null) {
            return (this.app.config().getAppPath() + this.path).replaceAll("//", "/");
        }
        return this.path;
    }

    protected org.http4k.core.Response handleEventRequest(Request request) {
        try {
            return this.toHttp4kResponse(this.app.run(this.toSlackRequest(request)));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildEventErrorResponse(request, e);
        }
    }

    protected org.http4k.core.Response handleOAuthRequest(Request request) {
        try {
            return this.toHttp4kResponse(this.app.run(this.toSlackRequest(request)));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildOAuthPageErrorResponse(request, e);
        }
    }

    protected org.http4k.core.Response buildEventErrorResponse(Request request, Exception e) {
        return org.http4k.core.Response.Companion.create(Status.INTERNAL_SERVER_ERROR).header("Content-Type", "application/json; charset=utf-8").body("{\"error\":\"An error occurred during processing of the request\"}");
    }

    protected org.http4k.core.Response buildOAuthPageErrorResponse(Request request, Exception e) {
        return org.http4k.core.Response.Companion.create(Status.INTERNAL_SERVER_ERROR).header("Content-Type", "text/plain; charset=utf-8").body("Internal Server Error");
    }

    protected org.http4k.core.Response notFound(Request request) {
        return org.http4k.core.Response.Companion.create(Status.NOT_FOUND).header("Content-Type", "text/plain; charset=utf-8").body("Not Found");
    }

    protected com.slack.api.bolt.request.Request<?> toSlackRequest(Request httpRequest) {
        Map<String, List> queryString = ParametersKt.toParameters((String)httpRequest.getUri().getQuery()).stream().collect(Collectors.toMap(Pair::component1, it -> Collections.singletonList((String)it.component2())));
        HashMap<String, List> underlyingHeaders = new HashMap<String, List>();
        for (Pair header : httpRequest.getHeaders()) {
            String name = (String)header.getFirst();
            List values = underlyingHeaders.getOrDefault(name, new ArrayList());
            values.add((String)header.getSecond());
            underlyingHeaders.put(name, values);
        }
        RequestHeaders headers = new RequestHeaders(underlyingHeaders);
        return this.requestParser.parse(SlackRequestParser.HttpRequest.builder().requestUri(httpRequest.getUri().getPath()).queryString(queryString).requestBody(httpRequest.bodyString()).headers(headers).remoteAddress(httpRequest.header("X-Forwarded-For")).build());
    }

    protected org.http4k.core.Response toHttp4kResponse(Response boltResponse) {
        Status status = new Status(boltResponse.getStatusCode().intValue(), "");
        List headers = boltResponse.getHeaders().entrySet().stream().flatMap(it -> ((List)it.getValue()).stream().map(it2 -> new Pair((Object)((String)it.getKey()), it2))).collect(Collectors.toList());
        if (boltResponse.getContentType() != null) {
            headers.add(new Pair((Object)"Content-Type", (Object)boltResponse.getContentType()));
        }
        String body = boltResponse.getBody();
        return org.http4k.core.Response.Companion.create(status).headers(headers).body(body == null ? "" : body);
    }
}

