/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.helidon;

import com.slack.api.bolt.App;
import com.slack.api.bolt.helidon.SlackAppService;
import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.Service;
import io.helidon.webserver.WebServer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class SlackAppServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlackAppServer.class);
    private final Config config;
    private final App apiApp;
    private final App oauthApp;
    private WebServer server;
    private int shutdownTimeoutSeconds = 10;
    private Function<Routing.Builder, Routing.Builder> additionalRoutingConfigurator = builder -> builder;

    public SlackAppServer(App apiApp) {
        this(Config.create(), apiApp, null);
    }

    public SlackAppServer(Config config, App apiApp) {
        this(config, apiApp, null);
    }

    public SlackAppServer(App apiApp, App oauthApp) {
        this(Config.create(), apiApp, oauthApp);
    }

    public SlackAppServer(Config config, App apiApp, App oauthApp) {
        this.config = config;
        this.apiApp = apiApp;
        this.oauthApp = oauthApp;
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    public int getPort() {
        return this.server.configuration().port();
    }

    public WebServer start() {
        if (this.server == null) {
            ServerConfiguration serverConfig = ServerConfiguration.create((Config)this.config.get("server"));
            this.server = WebServer.create((ServerConfiguration)serverConfig, (Routing)this.buildRouting(this.config));
        }
        this.server.start().thenAccept(ws -> {
            LOGGER.info("\u26a1\ufe0f Bolt app is running!");
            ws.whenShutdown().thenRun(() -> LOGGER.info("\u26a1\ufe0f Your Bolt app has stopped..."));
        }).exceptionally(t -> {
            LOGGER.error("Failed to start the server: " + t.getMessage(), t);
            return null;
        });
        return this.server;
    }

    public void stop() throws ExecutionException, InterruptedException, TimeoutException {
        if (this.server.isRunning()) {
            this.server.shutdown().toCompletableFuture().get(this.shutdownTimeoutSeconds, TimeUnit.SECONDS);
        }
    }

    protected Routing buildRouting(Config config) {
        SlackAppService apiService = new SlackAppService(config, this.apiApp);
        ConfigValue apiPathConfig = config.get("bolt.apiPath").asString();
        String apiPath = apiPathConfig.isPresent() ? (String)apiPathConfig.get() : "/slack/events";
        Routing.Builder builder = Routing.builder().register(apiPath, new Service[]{apiService});
        if (this.oauthApp != null) {
            SlackAppService oauthService = new SlackAppService(config, this.oauthApp);
            builder = builder.register(this.oauthApp.config().getOauthStartPath(), new Service[]{oauthService}).register(this.oauthApp.config().getOauthCallbackPath(), new Service[]{oauthService});
        }
        return this.getAdditionalRoutingConfigurator().apply(builder).build();
    }

    public Function<Routing.Builder, Routing.Builder> getAdditionalRoutingConfigurator() {
        return this.additionalRoutingConfigurator;
    }

    public void setAdditionalRoutingConfigurator(Function<Routing.Builder, Routing.Builder> additionalRoutingConfigurator) {
        this.additionalRoutingConfigurator = additionalRoutingConfigurator;
    }

    public int getShutdownTimeoutSeconds() {
        return this.shutdownTimeoutSeconds;
    }

    public void setShutdownTimeoutSeconds(int shutdownTimeoutSeconds) {
        this.shutdownTimeoutSeconds = shutdownTimeoutSeconds;
    }
}

