package com.sixwaves.swsdkapi.module;

//import androidx.annotation.NonNull;
//import androidx.annotation.WorkerThread;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.media.RingtoneManager;
import android.os.Build;

import androidx.core.app.NotificationCompat;

import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.sixwaves.swsdkapi.GeneralUtil;
import com.sixwaves.swsdkapi.SwNotificationCenter;
import com.sixwaves.swsdkapi.SwsdkAPI;

import java.util.HashMap;

/**
 * jcenter/bintray update log:
 * v1.0.3 remove unwanted file in aar
 * v1.0.2 minor bug fix
 * v1.0.0 = 'com.google.firebase:firebase-messaging:20.2.4'
 */
public class FirebaseFcmHelper extends FirebaseMessagingService {

    static int mid = 0;
    @Override
    public void onCreate() {
        SwsdkAPI.debugLog("FirebaseFcmHelper onCreate");

        super.onCreate();
    }
    @Override
    public void onDestroy() {
        SwsdkAPI.debugLog("FirebaseFcmHelper onDestroy");

        super.onDestroy();
    }

    //https://stackoverflow.com/questions/37711082/how-to-handle-notification-when-app-in-background-in-firebase
    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        SwsdkAPI.debugLog("FirebaseFcmHelper: onMessageReceived");
        SwsdkAPI.debugLog("if you cannot see icon, please check icon spec.\n " +
                "Icon needs to be transparent png with only white color");
        SwsdkAPI.debugLog("========================================================================================");
        SwsdkAPI.debugLog("icon name MUST be named ic_notification in drawable folders");

        SwsdkAPI.debugLog("if you need to see push msg when the app closed, you need to sent 'data' message,\n" +
                        ",a message without 'notification' section in json");
        SwsdkAPI.debugLog("if you sent 'data message', you must declare fields 'title' and 'body'");
        SwsdkAPI.debugLog("e.g.:\n{" +
                "    \"registration_ids\" : [\"id\"],\n" +
                "    \"data\": {\n" +
                "        \"title\": \"mytitle\",\n" +
                "        \"body\": \"mybody\",\n" +
                "     }\n" +
                "}");
        SwsdkAPI.debugLog("========================================================================================");


        HashMap<String,String> pushMsg = new HashMap<>();;

        // Check if message contains a notification payload.
        if (remoteMessage.getNotification() != null) {
//            SwsdkAPI.debugLog("Message Notification Title: " + remoteMessage.getNotification().getTitle());
//            SwsdkAPI.debugLog("Message Notification Body: " + remoteMessage.getNotification().getBody());


            pushMsg.put(SwsdkAPI.SWSDK_FCM_PUSH_TITLE,remoteMessage.getNotification().getTitle());
            pushMsg.put(SwsdkAPI.SWSDK_FCM_PUSH_BODY,remoteMessage.getNotification().getBody());
        }


        if (remoteMessage.getData().size() > 0) {

            pushMsg.putAll(remoteMessage.getData());
        }

        if(pushMsg.containsKey(SwsdkAPI.SWSDK_FCM_PUSH_TITLE)==false||
                pushMsg.containsKey(SwsdkAPI.SWSDK_FCM_PUSH_BODY)==false){
            SwsdkAPI.errorLog("FirebaseFcmHelper: push message no title or body");
            return;
        }

        String messageInJson = GeneralUtil.mapToString(pushMsg);
        HashMap<String,String>forwardMsg = new HashMap<>();
        forwardMsg.put(SwsdkAPI.SWSDK_PUSH_KEY,messageInJson);

        SwNotificationCenter.postNotification(this.getApplicationContext(),
                SwNotificationCenter.NotificationType.SdkReceivePushMsg,forwardMsg);

        PackageManager packageManager = this.getApplicationContext().getPackageManager();
        Intent intent = packageManager.getLaunchIntentForPackage(this.getApplicationContext().getPackageName());
        intent.putExtra(SwsdkAPI.SWSDK_PUSH_KEY,messageInJson);

        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        PendingIntent pendingIntent = PendingIntent.getActivity(this, 0 /* Request code */, intent,
                PendingIntent.FLAG_ONE_SHOT);

        int drawableResourceId = this.getResources().getIdentifier("ic_notification", "drawable", this.getApplicationContext().getPackageName());

        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(this, "fcm_default_channel")
                .setContentTitle(pushMsg.get(SwsdkAPI.SWSDK_FCM_PUSH_TITLE))
                .setContentText(pushMsg.get(SwsdkAPI.SWSDK_FCM_PUSH_BODY))
                .setPriority(NotificationCompat.PRIORITY_DEFAULT)
                .setStyle(new NotificationCompat.BigTextStyle())
                .setSound(RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION))
                .setAutoCancel(true)
                .setSmallIcon(drawableResourceId)
                .setContentIntent(pendingIntent)
                ;

        NotificationManager notificationManager =
                (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);


        // Since android Oreo notification channel is needed.
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {

            NotificationChannel channel = new NotificationChannel("fcm_default_channel",
                    "Notification channel",
                    NotificationManager.IMPORTANCE_DEFAULT);
            notificationManager.createNotificationChannel(channel);
        }

        notificationManager.notify(mid++, notificationBuilder.build());

    }

    @Override
    public void onNewToken(String var1) {
        SwsdkAPI.debugLog("receive FCM token:"+var1);
        HashMap<String,String> params = new HashMap<String,String>();
        params.put(SwsdkAPI.SWSDK_FCM_TOKEN_KEY,var1);

        SwNotificationCenter.postNotification(this.getApplicationContext(),
                SwNotificationCenter.NotificationType.SdkAutoFcmToken,params);

        //enforce subscribe to 1 topic for using data message when needed
        FirebaseFcmHelper.subscribeToTopic(SwsdkAPI.SWSDK_FCM_DEFAULT_TOPIC);
    }

    public static void fetchFcmToken(final Context context){


        FirebaseInstanceId.getInstance().getInstanceId()
                .addOnCompleteListener(new OnCompleteListener<InstanceIdResult>() {
                    @Override
                    public void onComplete(Task<InstanceIdResult> task) {
                        if (!task.isSuccessful()) {
                            SwsdkAPI.errorLog("Fetch FCM token failed");
                            if(task.getException()!=null)
                                task.getException().printStackTrace();

                            SwNotificationCenter.postNotification(context,
                                    SwNotificationCenter.NotificationType.SdkManualFcmTokenFail,null);
                            return;
                        }

                        // Get new Instance ID token
                        String token = task.getResult().getToken();
                        HashMap<String,String> params = new HashMap<String,String>();
                        params.put(SwsdkAPI.SWSDK_FCM_TOKEN_KEY,token);
                        SwNotificationCenter.postNotification(context,
                                SwNotificationCenter.NotificationType.SdkManualFcmToken,params);

                    }
                });
    }
    public static void subscribeToTopic(final String topic) {
        FirebaseMessaging.getInstance().subscribeToTopic(topic);
    }
    public static void unsubscribeFromTopic(final String topic) {
        FirebaseMessaging.getInstance().unsubscribeFromTopic(topic);
    }
}
