/*
 * Decompiled with CFR 0.152.
 */
package com.sixwaves.swsdkapi.module;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.media.RingtoneManager;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.sixwaves.swsdkapi.SwNotificationCenter;
import com.sixwaves.swsdkapi.SwsdkAPI;
import java.util.HashMap;

public class FirebaseFcmHelper
extends FirebaseMessagingService {
    static int mid = 0;

    public void onCreate() {
        SwsdkAPI.debugLog((String)"FirebaseFcmHelper onCreate");
        super.onCreate();
    }

    public void onDestroy() {
        SwsdkAPI.debugLog((String)"FirebaseFcmHelper onDestroy");
        super.onDestroy();
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        SwsdkAPI.debugLog((String)"FirebaseFcmHelper: onMessageReceived");
        SwsdkAPI.debugLog((String)"if you cannot see icon, please check icon spec.\n Icon needs to be transparent png with only white color");
        SwsdkAPI.debugLog((String)"========================================================================================");
        SwsdkAPI.debugLog((String)"icon name MUST be named ic_notification in drawable folders");
        SwsdkAPI.debugLog((String)"if you need to see push msg when the app closed, you need to sent 'data' message,\n,a message without 'notification' section in json");
        SwsdkAPI.debugLog((String)"if you sent 'data message', you must declare fields 'title' and 'body'");
        SwsdkAPI.debugLog((String)"e.g.:\n{    \"registration_ids\" : [\"id\"],\n    \"data\": {\n        \"title\": \"mytitle\",\n        \"body\": \"mybody\",\n     }\n}");
        SwsdkAPI.debugLog((String)"========================================================================================");
        HashMap<String, String> pushMsg = new HashMap<String, String>();
        if (remoteMessage.getNotification() != null) {
            pushMsg.put("title", remoteMessage.getNotification().getTitle());
            pushMsg.put("body", remoteMessage.getNotification().getBody());
        }
        if (remoteMessage.getData().size() > 0) {
            pushMsg.putAll(remoteMessage.getData());
        }
        if (!pushMsg.containsKey("title") || !pushMsg.containsKey("body")) {
            SwsdkAPI.errorLog((String)"FirebaseFcmHelper: push message no title or body");
            return;
        }
        SwNotificationCenter.postNotification((Context)this.getApplicationContext(), (SwNotificationCenter.NotificationType)SwNotificationCenter.NotificationType.SdkReceivePushMsg, pushMsg);
        PackageManager packageManager = this.getApplicationContext().getPackageManager();
        Intent intent = packageManager.getLaunchIntentForPackage(this.getApplicationContext().getPackageName());
        intent.putExtra("SwPush", pushMsg);
        intent.addFlags(0x4000000);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x40000000);
        int drawableResourceId = this.getResources().getIdentifier("ic_notification", "drawable", this.getApplicationContext().getPackageName());
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder((Context)this, "fcm_default_channel").setContentTitle((CharSequence)pushMsg.get("title")).setContentText((CharSequence)pushMsg.get("body")).setPriority(0).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle()).setSound(RingtoneManager.getDefaultUri((int)2)).setAutoCancel(true).setSmallIcon(drawableResourceId).setContentIntent(pendingIntent);
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel("fcm_default_channel", (CharSequence)"Notification channel", 3);
            notificationManager.createNotificationChannel(channel);
        }
        notificationManager.notify(mid++, notificationBuilder.build());
    }

    public void onNewToken(String var1) {
        SwsdkAPI.debugLog((String)("receive FCM token:" + var1));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SwfcmToken", var1);
        SwNotificationCenter.postNotification((Context)this.getApplicationContext(), (SwNotificationCenter.NotificationType)SwNotificationCenter.NotificationType.SdkAutoFcmToken, params);
    }

    public static void fetchFcmToken(final Context context) {
        FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

            public void onComplete(Task<InstanceIdResult> task) {
                if (!task.isSuccessful()) {
                    SwsdkAPI.errorLog((String)"Fetch FCM token failed");
                    if (task.getException() != null) {
                        task.getException().printStackTrace();
                    }
                    SwNotificationCenter.postNotification((Context)context, (SwNotificationCenter.NotificationType)SwNotificationCenter.NotificationType.SdkManualFcmTokenFail, null);
                    return;
                }
                String token = ((InstanceIdResult)task.getResult()).getToken();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("SwfcmToken", token);
                SwNotificationCenter.postNotification((Context)context, (SwNotificationCenter.NotificationType)SwNotificationCenter.NotificationType.SdkManualFcmToken, params);
            }
        });
    }

    public static void subscribeToTopic(String topic) {
        FirebaseMessaging.getInstance().subscribeToTopic("topic");
    }

    public static void unsubscribeFromTopic(String topic) {
        FirebaseMessaging.getInstance().unsubscribeFromTopic("topic");
    }
}

