/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd;

import com.jme3.math.Vector3f;
import com.simsilica.mathd.Vec3i;
import java.io.Serializable;

public class Vec3d
implements Cloneable,
Serializable {
    static final long serialVersionUID = 42L;
    public static final Vec3d UNIT_X = new Vec3d(1.0, 0.0, 0.0);
    public static final Vec3d UNIT_Y = new Vec3d(0.0, 1.0, 0.0);
    public static final Vec3d UNIT_Z = new Vec3d(0.0, 0.0, 1.0);
    public static final Vec3d ZERO = new Vec3d();
    public double x;
    public double y;
    public double z;

    public Vec3d() {
    }

    public Vec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3d(Vec3d v) {
        this(v.x, v.y, v.z);
    }

    public Vec3d(Vector3f v) {
        this(v.x, v.y, v.z);
    }

    public Vector3f toVector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.x);
        bits ^= Double.doubleToLongBits(this.y) * 31L;
        return (int)(bits ^= Double.doubleToLongBits(this.z) * 31L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Vec3d other = (Vec3d)o;
        if (other.x != this.x) {
            return false;
        }
        if (other.y != this.y) {
            return false;
        }
        return other.z == this.z;
    }

    public boolean isSimilar(Vec3d other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (Double.compare(Math.abs(other.x - this.x), epsilon) > 0) {
            return false;
        }
        if (Double.compare(Math.abs(other.y - this.y), epsilon) > 0) {
            return false;
        }
        return Double.compare(Math.abs(other.z - this.z), epsilon) <= 0;
    }

    public final Vec3d set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public final Vec3d set(Vec3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public final Vec3d set(Vec3i v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public final Vec3d set(Vector3f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public final Vec3i toVec3i() {
        return new Vec3i((int)this.x, (int)this.y, (int)this.z);
    }

    public final Vec3i floor() {
        return new Vec3i((int)Math.floor(this.x), (int)Math.floor(this.y), (int)Math.floor(this.z));
    }

    public final Vec3i ceil() {
        return new Vec3i((int)Math.ceil(this.x), (int)Math.ceil(this.y), (int)Math.ceil(this.z));
    }

    public final Vec3d clone() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public double get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException("Index:" + i);
    }

    public Vec3d set(int i, double d) {
        switch (i) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            case 2: {
                this.z = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Index:" + i);
            }
        }
        return this;
    }

    public final Vec3d add(Vec3d v) {
        return new Vec3d(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public final Vec3d add(double vx, double vy, double vz) {
        return new Vec3d(this.x + vx, this.y + vy, this.z + vz);
    }

    public final Vec3d subtract(Vec3d v) {
        return new Vec3d(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public final Vec3d subtract(double vx, double vy, double vz) {
        return new Vec3d(this.x - vx, this.y - vy, this.z - vz);
    }

    public final Vec3d mult(double s) {
        return new Vec3d(this.x * s, this.y * s, this.z * s);
    }

    public final Vec3d mult(Vec3d v) {
        return new Vec3d(this.x * v.x, this.y * v.y, this.z * v.z);
    }

    public final Vec3d divide(double s) {
        return new Vec3d(this.x / s, this.y / s, this.z / s);
    }

    public final Vec3d divide(Vec3d v) {
        return new Vec3d(this.x / v.x, this.y / v.y, this.z / v.z);
    }

    public final Vec3d addLocal(Vec3d v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public final Vec3d addLocal(double vx, double vy, double vz) {
        this.x += vx;
        this.y += vy;
        this.z += vz;
        return this;
    }

    public final Vec3d subtractLocal(Vec3d v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public final Vec3d subtractLocal(double vx, double vy, double vz) {
        this.x -= vx;
        this.y -= vy;
        this.z -= vz;
        return this;
    }

    public final Vec3d multLocal(double s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
        return this;
    }

    public final Vec3d multLocal(Vec3d v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }

    public final Vec3d divideLocal(double s) {
        this.x /= s;
        this.y /= s;
        this.z /= s;
        return this;
    }

    public final Vec3d divideLocal(Vec3d v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        return this;
    }

    public final double lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double length() {
        return Math.sqrt(this.lengthSq());
    }

    public final double distanceSq(Vec3d v) {
        double xs = v.x - this.x;
        double ys = v.y - this.y;
        double zs = v.z - this.z;
        return xs * xs + ys * ys + zs * zs;
    }

    public final double distance(Vec3d v) {
        return Math.sqrt(this.distanceSq(v));
    }

    public final double distanceSq(double vx, double vy, double vz) {
        double xs = vx - this.x;
        double ys = vy - this.y;
        double zs = vz - this.z;
        return xs * xs + ys * ys + zs * zs;
    }

    public final double distance(double vx, double vy, double vz) {
        return Math.sqrt(this.distanceSq(vx, vy, vz));
    }

    public final Vec3d normalize() {
        return this.mult(1.0 / this.length());
    }

    public final Vec3d normalizeLocal() {
        return this.multLocal(1.0 / this.length());
    }

    public final double dot(Vec3d v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final double dot(double vx, double vy, double vz) {
        return this.x * vx + this.y * vy + this.z * vz;
    }

    public final Vec3d cross(Vec3d v) {
        double xNew = this.y * v.z - this.z * v.y;
        double yNew = this.z * v.x - this.x * v.z;
        double zNew = this.x * v.y - this.y * v.x;
        return new Vec3d(xNew, yNew, zNew);
    }

    public final Vec3d cross(double vx, double vy, double vz) {
        double xNew = this.y * vz - this.z * vy;
        double yNew = this.z * vx - this.x * vz;
        double zNew = this.x * vy - this.y * vx;
        return new Vec3d(xNew, yNew, zNew);
    }

    public final Vec3d crossLocal(Vec3d v) {
        double xNew = this.y * v.z - this.z * v.y;
        double yNew = this.z * v.x - this.x * v.z;
        double zNew = this.x * v.y - this.y * v.x;
        this.x = xNew;
        this.y = yNew;
        this.z = zNew;
        return this;
    }

    public final Vec3d addScaledVectorLocal(Vec3d toAdd, double scale) {
        this.x += toAdd.x * scale;
        this.y += toAdd.y * scale;
        this.z += toAdd.z * scale;
        return this;
    }

    public final Vec3d minLocal(Vec3d v) {
        this.x = this.x < v.x ? this.x : v.x;
        this.y = this.y < v.y ? this.y : v.y;
        this.z = this.z < v.z ? this.z : v.z;
        return this;
    }

    public final Vec3d maxLocal(Vec3d v) {
        this.x = this.x > v.x ? this.x : v.x;
        this.y = this.y > v.y ? this.y : v.y;
        this.z = this.z > v.z ? this.z : v.z;
        return this;
    }

    public final Vec3d zeroEpsilon(double e) {
        if (this.x > -e && this.x < e) {
            this.x = 0.0;
        }
        if (this.y > -e && this.y < e) {
            this.y = 0.0;
        }
        if (this.z > -e && this.z < e) {
            this.z = 0.0;
        }
        return this;
    }

    public final Vec3d interpolateLocal(Vec3d start, Vec3d end, double mix) {
        this.x = (1.0 - mix) * start.x + mix * end.x;
        this.y = (1.0 - mix) * start.y + mix * end.y;
        this.z = (1.0 - mix) * start.z + mix * end.z;
        return this;
    }

    public final Vec3d xzy() {
        return new Vec3d(this.x, this.z, this.y);
    }

    public String toString() {
        return "Vec3d[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

