/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.phase01generatesources;

import com.android.builder.core.DefaultManifestParser;
import com.android.builder.symbols.RGeneration;
import com.android.builder.symbols.SymbolIo;
import com.android.builder.symbols.SymbolTable;
import com.simpligility.maven.plugins.android.phase01generatesources.GenerateSourcesMojo;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;

final class ResourceClassGenerator {
    private final GenerateSourcesMojo mojo;
    private final File targetDirectory;
    private final File genDirectory;
    private final Log log;
    private final ClassLoader compileClassLoader;

    ResourceClassGenerator(GenerateSourcesMojo mojo, File targetDirectory, File genDirectory, ClassLoader compileClassLoader) {
        this.mojo = mojo;
        this.targetDirectory = targetDirectory;
        this.genDirectory = genDirectory;
        this.log = mojo.getLog();
        this.compileClassLoader = compileClassLoader;
    }

    public void generateLibraryRs(Set<Artifact> libraries) {
        ArrayList<SymbolTable> symbolTables = new ArrayList<SymbolTable>(libraries.size());
        for (Artifact lib : libraries) {
            File unpackedLibDirectory = this.mojo.getUnpackedLibFolder(lib);
            File rFile = new File(unpackedLibDirectory, "R.txt");
            if (!rFile.isFile()) continue;
            File libManifestFile = new File(unpackedLibDirectory, "AndroidManifest.xml");
            String packageName = new DefaultManifestParser(libManifestFile).getPackage();
            if (this.rJavaAlreadyExists(packageName)) {
                this.log.info((CharSequence)("Not creating R for " + packageName + " as it already exists"));
                continue;
            }
            this.log.info((CharSequence)("Generating R for " + packageName + " at " + rFile));
            SymbolTable libSymbols = SymbolIo.read((File)rFile);
            libSymbols = libSymbols.rename(packageName, libSymbols.getTableName());
            symbolTables.add(libSymbols);
        }
        if (symbolTables.isEmpty()) {
            return;
        }
        File projectR = new File(this.targetDirectory, "R.txt");
        SymbolTable mainSymbols = SymbolIo.read((File)projectR);
        RGeneration.generateRForLibraries((SymbolTable)mainSymbols, symbolTables, (File)this.genDirectory.getAbsoluteFile(), (boolean)false);
    }

    private boolean rJavaAlreadyExists(String packageName) {
        String rJavaClass = packageName + ".R";
        try {
            this.compileClassLoader.loadClass(rJavaClass);
            return true;
        }
        catch (ClassNotFoundException e) {
            this.log.debug((CharSequence)("Could not resolve R java : " + rJavaClass));
            return false;
        }
    }
}

