/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.common;

import com.android.ddmlib.IDevice;
import com.simpligility.maven.plugins.android.common.FileNameHelper;
import org.apache.commons.lang3.StringUtils;

public class DeviceHelper {
    private static final String MANUFACTURER_PROPERTY = "ro.product.manufacturer";
    private static final String MODEL_PROPERTY = "ro.product.model";
    private static final String SEPARATOR = "_";

    public static String getDescriptiveName(IDevice device) {
        String model;
        String manufacturer;
        StringBuilder identfier = new StringBuilder().append(device.getSerialNumber());
        if (device.getAvdName() != null) {
            identfier.append(SEPARATOR).append(device.getAvdName());
        }
        if (StringUtils.isNotBlank((CharSequence)(manufacturer = DeviceHelper.getManufacturer(device)))) {
            identfier.append(SEPARATOR).append(manufacturer);
        }
        if (StringUtils.isNotBlank((CharSequence)(model = DeviceHelper.getModel(device)))) {
            identfier.append(SEPARATOR).append(model);
        }
        return FileNameHelper.fixFileName(identfier.toString());
    }

    public static String getDeviceLogLinePrefix(IDevice device) {
        return DeviceHelper.getDescriptiveName(device) + " :   ";
    }

    public static String getManufacturer(IDevice device) {
        return StringUtils.deleteWhitespace((String)device.getProperty(MANUFACTURER_PROPERTY));
    }

    public static String getModel(IDevice device) {
        return StringUtils.deleteWhitespace((String)device.getProperty(MODEL_PROPERTY));
    }

    public static String getDescriptiveNameWithStatus(IDevice device) {
        String status = device.isOnline() ? "Online" : (device.isOffline() ? "Offline" : "Unknown");
        return DeviceHelper.getDescriptiveName(device) + " " + status;
    }
}

