/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android;

import com.simpligility.maven.plugins.android.ExecutionException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.shell.Shell;

public interface CommandExecutor {
    public void setLogger(Log var1);

    public void executeCommand(String var1, List<String> var2) throws ExecutionException;

    public void executeCommand(String var1, List<String> var2, boolean var3) throws ExecutionException;

    public void executeCommand(String var1, List<String> var2, File var3, boolean var4) throws ExecutionException;

    public int getResult();

    public long getPid();

    public String getStandardOut();

    public String getStandardError();

    public void addEnvironment(String var1, String var2);

    public void setErrorListener(ErrorListener var1);

    public void setCustomShell(Shell var1);

    public void setCaptureStdOut(boolean var1);

    public void setCaptureStdErr(boolean var1);

    public static class Factory {
        private Factory() {
        }

        public static CommandExecutor createDefaultCommmandExecutor() {
            return new DefaultCommandExecutor();
        }

        static class ErrorStreamConsumer
        implements StreamConsumer {
            private boolean error;
            private StringBuffer sbe = new StringBuffer();
            private final Log logger;
            private final ErrorListener errorListener;
            private boolean captureStdErr;

            ErrorStreamConsumer(Log logger, ErrorListener errorListener, boolean captureStdErr) {
                this.logger = logger;
                this.errorListener = errorListener;
                this.captureStdErr = captureStdErr;
                if (logger == null) {
                    System.out.println("ANDROID-040-003: Error Log not set: Will not output error logs");
                }
                this.error = false;
            }

            public void consumeLine(String line) {
                if (this.captureStdErr) {
                    this.sbe.append(line);
                }
                if (this.logger != null) {
                    this.logger.info((CharSequence)line);
                }
                this.error = this.errorListener != null ? this.errorListener.isError(line) : true;
            }

            public boolean hasError() {
                return this.error;
            }

            public String toString() {
                return this.sbe.toString();
            }
        }

        static class StreamConsumerImpl
        implements StreamConsumer {
            private StringBuffer sb = new StringBuffer();
            private final Log logger;
            private boolean captureStdOut;

            StreamConsumerImpl(Log logger, boolean captureStdOut) {
                this.logger = logger;
                this.captureStdOut = captureStdOut;
            }

            public void consumeLine(String line) {
                if (this.captureStdOut) {
                    this.sb.append(line).append('\n');
                }
                if (this.logger != null) {
                    this.logger.debug((CharSequence)line);
                }
            }

            public String toString() {
                return this.sb.toString();
            }
        }

        private static final class DefaultCommandExecutor
        implements CommandExecutor {
            private Map<String, String> environment;
            private Log logger;
            private StreamConsumer stdOut;
            private ErrorStreamConsumer stdErr;
            private int result;
            private ErrorListener errorListener;
            long pid;
            private Commandline commandline;
            private Shell customShell;
            private boolean captureStdOut;
            private boolean captureStdErr;

            private DefaultCommandExecutor() {
            }

            @Override
            public void setLogger(Log logger) {
                this.logger = logger;
            }

            @Override
            public void executeCommand(String executable, List<String> commands) throws ExecutionException {
                this.executeCommand(executable, commands, null, true);
            }

            @Override
            public void executeCommand(String executable, List<String> commands, boolean failsOnErrorOutput) throws ExecutionException {
                this.executeCommand(executable, commands, null, failsOnErrorOutput);
            }

            @Override
            public void executeCommand(String executable, List<String> commands, File workingDirectory, boolean failsOnErrorOutput) throws ExecutionException {
                if (commands == null) {
                    commands = new ArrayList<String>();
                }
                this.stdOut = new StreamConsumerImpl(this.logger, this.captureStdOut);
                this.stdErr = new ErrorStreamConsumer(this.logger, this.errorListener, this.captureStdErr);
                this.commandline = new Commandline();
                if (this.customShell != null) {
                    this.commandline.setShell(this.customShell);
                }
                this.commandline.setExecutable(executable);
                if (this.environment != null) {
                    for (Map.Entry<String, String> entry : this.environment.entrySet()) {
                        this.commandline.addEnvironment(entry.getKey(), entry.getValue());
                    }
                }
                this.commandline.addArguments(commands.toArray(new String[commands.size()]));
                if (workingDirectory != null && workingDirectory.exists()) {
                    this.commandline.setWorkingDirectory(workingDirectory.getAbsolutePath());
                }
                try {
                    this.logger.debug((CharSequence)("ANDROID-040-000: Executing command: Commandline = " + this.commandline));
                    this.result = CommandLineUtils.executeCommandLine((Commandline)this.commandline, (StreamConsumer)this.stdOut, (StreamConsumer)this.stdErr);
                    if (this.logger != null) {
                        this.logger.debug((CharSequence)("ANDROID-040-000: Executed command: Commandline = " + this.commandline + ", Result = " + this.result));
                    } else {
                        System.out.println("ANDROID-040-000: Executed command: Commandline = " + this.commandline + ", Result = " + this.result);
                    }
                    if (failsOnErrorOutput && this.stdErr.hasError() || this.result != 0) {
                        throw new ExecutionException("ANDROID-040-001: Could not execute: Command = " + this.commandline.toString() + ", Result = " + this.result);
                    }
                }
                catch (CommandLineException e) {
                    throw new ExecutionException("ANDROID-040-002: Could not execute: Command = " + this.commandline.toString() + ", Error message = " + e.getMessage());
                }
                this.setPid(this.commandline.getPid());
            }

            @Override
            public int getResult() {
                return this.result;
            }

            @Override
            public String getStandardOut() {
                if (!this.captureStdOut) {
                    throw new IllegalStateException("Unable to provide StdOut since it was not captured");
                }
                return this.stdOut.toString();
            }

            @Override
            public String getStandardError() {
                if (!this.captureStdErr) {
                    throw new IllegalStateException("Unable to provide StdOut since it was not captured");
                }
                return this.stdErr.toString();
            }

            @Override
            public void addEnvironment(String name, String value) {
                if (this.environment == null) {
                    this.environment = new HashMap<String, String>();
                }
                this.environment.put(name, value);
            }

            @Override
            public void setErrorListener(ErrorListener errorListener) {
                this.errorListener = errorListener;
            }

            public void setPid(long pid) {
                this.pid = pid;
            }

            @Override
            public long getPid() {
                return this.pid;
            }

            @Override
            public void setCustomShell(Shell shell) {
                this.customShell = shell;
            }

            @Override
            public void setCaptureStdOut(boolean captureStdOut) {
                this.captureStdOut = captureStdOut;
            }

            @Override
            public void setCaptureStdErr(boolean captureStdErr) {
                this.captureStdErr = captureStdErr;
            }
        }
    }

    public static interface ErrorListener {
        public boolean isError(String var1);
    }
}

