/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.simpligility.maven.plugins.android.common.DeviceHelper;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.surefire.ObjectFactory;
import org.apache.maven.surefire.Testsuite;

public class AndroidTestRunListener
implements ITestRunListener {
    private static final String SCREENSHOT_SUFFIX = "_screenshot.png";
    private static final String INDENT = "  ";
    private final NumberFormat timeFormatter = new DecimalFormat("#0.000");
    private int testCount = 0;
    private int testRunCount = 0;
    private int testIgnoredCount = 0;
    private int testFailureCount = 0;
    private int testErrorCount = 0;
    private String testRunFailureCause = null;
    private final IDevice device;
    private final Log log;
    private final Boolean createReport;
    private final Boolean takeScreenshotOnFailure;
    private final String screenshotsPathOnDevice;
    private final String reportSuffix;
    private final File targetDirectory;
    private final String deviceLogLinePrefix;
    private final ObjectFactory objectFactory = new ObjectFactory();
    private Testsuite report;
    private Testsuite.Testcase currentTestCase;
    private long currentTestCaseStartTime;
    private boolean threwException = false;
    private final StringBuilder exceptionMessages = new StringBuilder();

    public AndroidTestRunListener(IDevice device, Log log, Boolean createReport, Boolean takeScreenshotOnFailure, String screenshotsPathOnDevice, String reportSuffix, File targetDirectory) {
        this.device = device;
        this.deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
        this.log = log;
        this.createReport = createReport;
        this.takeScreenshotOnFailure = takeScreenshotOnFailure;
        this.screenshotsPathOnDevice = screenshotsPathOnDevice;
        this.reportSuffix = reportSuffix;
        this.targetDirectory = targetDirectory;
    }

    public Log getLog() {
        return this.log;
    }

    public void testRunStarted(String runName, int tCount) {
        if (this.takeScreenshotOnFailure.booleanValue()) {
            this.executeOnAdbShell("rm -f " + this.screenshotsPathOnDevice + "/*screenshot.png");
            this.executeOnAdbShell("mkdir " + this.screenshotsPathOnDevice);
        }
        this.testCount = tCount;
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run started: " + runName + ", " + this.testCount + " tests:"));
        if (this.createReport.booleanValue()) {
            this.report = new Testsuite();
            this.report.setName(runName);
            Testsuite.Properties props = new Testsuite.Properties();
            this.report.getProperties().add(props);
            for (Map.Entry<Object, Object> systemProperty : System.getProperties().entrySet()) {
                Testsuite.Properties.Property property = new Testsuite.Properties.Property();
                property.setName(systemProperty.getKey().toString());
                property.setValue(systemProperty.getValue().toString());
                props.getProperty().add(property);
            }
            Map deviceProperties = this.device.getProperties();
            for (Map.Entry deviceProperty : deviceProperties.entrySet()) {
                Testsuite.Properties.Property property = new Testsuite.Properties.Property();
                property.setName((String)deviceProperty.getKey());
                property.setValue((String)deviceProperty.getValue());
                props.getProperty().add(property);
            }
        }
    }

    public void testIgnored(TestIdentifier testIdentifier) {
        ++this.testIgnoredCount;
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + testIdentifier.toString()));
    }

    public void testStarted(TestIdentifier testIdentifier) {
        ++this.testRunCount;
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + String.format("%1$s%1$sStart [%2$d/%3$d]: %4$s", INDENT, this.testRunCount, this.testCount, testIdentifier.toString())));
        if (this.createReport.booleanValue()) {
            this.currentTestCaseStartTime = System.currentTimeMillis();
            this.currentTestCase = new Testsuite.Testcase();
            this.currentTestCase.setClassname(testIdentifier.getClassName());
            this.currentTestCase.setName(testIdentifier.getTestName());
        }
    }

    public void testFailed(TestIdentifier testIdentifier, String trace) {
        if (this.takeScreenshotOnFailure.booleanValue()) {
            String suffix = "_error";
            String filepath = testIdentifier.getTestName() + suffix + SCREENSHOT_SUFFIX;
            this.executeOnAdbShell("screencap -p " + this.screenshotsPathOnDevice + "/" + filepath);
            this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + filepath + " saved."));
        }
        ++this.testErrorCount;
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + testIdentifier.toString()));
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + trace));
        if (this.createReport.booleanValue()) {
            Testsuite.Testcase.Error error = new Testsuite.Testcase.Error();
            error.setValue(trace);
            error.setMessage(this.parseForMessage(trace));
            error.setType(this.parseForException(trace));
            this.currentTestCase.setError(this.objectFactory.createTestsuiteTestcaseError(error));
        }
    }

    public void testAssumptionFailure(TestIdentifier testIdentifier, String trace) {
        if (this.takeScreenshotOnFailure.booleanValue()) {
            String suffix = "_failure";
            String filepath = testIdentifier.getTestName() + suffix + SCREENSHOT_SUFFIX;
            this.executeOnAdbShell("screencap -p " + this.screenshotsPathOnDevice + "/" + filepath);
            this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + filepath + " saved."));
        }
        ++this.testFailureCount;
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + testIdentifier.toString()));
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + trace));
        if (this.createReport.booleanValue()) {
            Testsuite.Testcase.Failure failure = new Testsuite.Testcase.Failure();
            failure.setValue(trace);
            failure.setMessage(this.parseForMessage(trace));
            failure.setType(this.parseForException(trace));
            this.currentTestCase.getFailure().add(failure);
        }
    }

    private void executeOnAdbShell(String command) {
        try {
            this.device.executeShellCommand(command, new IShellOutputReceiver(){

                public boolean isCancelled() {
                    return false;
                }

                public void flush() {
                }

                public void addOutput(byte[] data, int offset, int length) {
                }
            });
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            this.getLog().error(e);
        }
    }

    public void testEnded(TestIdentifier testIdentifier, Map<String, String> testMetrics) {
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + String.format("%1$s%1$sEnd [%2$d/%3$d]: %4$s", INDENT, this.testRunCount, this.testCount, testIdentifier.toString())));
        this.logMetrics(testMetrics);
        if (this.createReport.booleanValue()) {
            double seconds = (double)(System.currentTimeMillis() - this.currentTestCaseStartTime) / 1000.0;
            this.currentTestCase.setTime(this.timeFormatter.format(seconds));
            this.report.getTestcase().add(this.currentTestCase);
        }
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run ended: " + elapsedTime + " ms"));
        if (this.hasFailuresOrErrors()) {
            this.getLog().error((CharSequence)(this.deviceLogLinePrefix + INDENT + "FAILURES!!!"));
        }
        this.getLog().info((CharSequence)("  Tests run: " + this.testRunCount + (this.testRunCount < this.testCount ? " (of " + this.testCount + ")" : "") + ",  Failures: " + this.testFailureCount + ",  Errors: " + this.testErrorCount + ",  Ignored: " + this.testIgnoredCount));
        if (this.createReport.booleanValue()) {
            this.report.setTests(Integer.toString(this.testCount));
            this.report.setFailures(Integer.toString(this.testFailureCount));
            this.report.setErrors(Integer.toString(this.testErrorCount));
            this.report.setSkipped(Integer.toString(this.testIgnoredCount));
            this.report.setTime(this.timeFormatter.format((double)elapsedTime / 1000.0));
        }
        this.logMetrics(runMetrics);
        if (this.createReport.booleanValue()) {
            this.writeJunitReportToFile();
        }
    }

    public void testRunFailed(String errorMessage) {
        this.testRunFailureCause = errorMessage;
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run failed: " + errorMessage));
    }

    public void testRunStopped(long elapsedTime) {
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run stopped:" + elapsedTime));
    }

    private String parseForMessage(String trace) {
        if (StringUtils.isNotBlank((CharSequence)trace)) {
            boolean hasMessage;
            String newline = "\r\n";
            int messageEnd = trace.indexOf(newline);
            boolean bl = hasMessage = !trace.startsWith("junit.") && messageEnd > 0;
            if (hasMessage) {
                int messageStart = trace.indexOf(":") + 2;
                if (messageStart > messageEnd && messageStart > (messageEnd = trace.indexOf(newline + "at"))) {
                    messageStart = 0;
                }
                return trace.substring(messageStart, messageEnd);
            }
            return "";
        }
        return "";
    }

    private String parseForException(String trace) {
        if (StringUtils.isNotBlank((CharSequence)trace)) {
            return trace.substring(0, trace.indexOf(":"));
        }
        return "";
    }

    private void writeJunitReportToFile() {
        try {
            String directory = String.valueOf(this.targetDirectory) + "/surefire-reports";
            FileUtils.forceMkdir((File)new File(directory));
            StringBuilder b = new StringBuilder(directory).append("/TEST-").append(DeviceHelper.getDescriptiveName(this.device));
            if (StringUtils.isNotBlank((CharSequence)this.reportSuffix)) {
                b.append(this.reportSuffix.replace("/", "").replace("\\", ""));
            }
            File reportFile = new File(b.append(".xml").toString());
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal((Object)this.report, reportFile);
            this.getLog().info((CharSequence)(this.deviceLogLinePrefix + "Report file written to " + reportFile.getAbsolutePath()));
        }
        catch (IOException e) {
            this.threwException = true;
            this.exceptionMessages.append("Failed to write test report file");
            this.exceptionMessages.append(e.getMessage());
        }
        catch (JAXBException e) {
            this.threwException = true;
            this.exceptionMessages.append("Failed to create jaxb context");
            this.exceptionMessages.append(e.getMessage());
        }
    }

    private void logMetrics(Map<String, String> metrics) {
        for (Map.Entry<String, String> entry : metrics.entrySet()) {
            this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + entry.getKey() + ": " + entry.getValue()));
        }
    }

    public boolean hasFailuresOrErrors() {
        return this.testErrorCount > 0 || this.testFailureCount > 0;
    }

    public boolean testRunFailed() {
        return this.testRunFailureCause != null;
    }

    public String getTestRunFailureCause() {
        return this.testRunFailureCause;
    }

    public boolean threwException() {
        return this.threwException;
    }

    public String getExceptionMessages() {
        return this.exceptionMessages.toString();
    }
}

