/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.render.effect;

import android.graphics.Color;
import android.opengl.GLSurfaceView;
import com.shuyu.gsyvideoplayer.render.view.GSYVideoGLView;

public class DuotoneEffect
implements GSYVideoGLView.ShaderInterface {
    private int mFirstColor = -65281;
    private int mSecondColor = -256;

    public DuotoneEffect(int mFirstColor, int mSecondColor) {
        this.mFirstColor = mFirstColor;
        this.mSecondColor = mSecondColor;
    }

    @Override
    public String getShader(GLSurfaceView mGlSurfaceView) {
        float[] first = new float[]{(float)Color.red((int)this.mFirstColor) / 255.0f, (float)Color.green((int)this.mFirstColor) / 255.0f, (float)Color.blue((int)this.mFirstColor) / 255.0f};
        float[] second = new float[]{(float)Color.red((int)this.mSecondColor) / 255.0f, (float)Color.green((int)this.mSecondColor) / 255.0f, (float)Color.blue((int)this.mSecondColor) / 255.0f};
        String[] firstColorString = new String[3];
        String[] secondColorString = new String[3];
        firstColorString[0] = "first[0] = " + first[0] + ";\n";
        firstColorString[1] = "first[1] = " + first[1] + ";\n";
        firstColorString[2] = "first[2] = " + first[2] + ";\n";
        secondColorString[0] = "second[0] = " + second[0] + ";\n";
        secondColorString[1] = "second[1] = " + second[1] + ";\n";
        secondColorString[2] = "second[2] = " + second[2] + ";\n";
        String shader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\n vec3 first;\n vec3 second;\nvarying vec2 vTextureCoord;\nvoid main() {\n" + firstColorString[0] + firstColorString[1] + firstColorString[2] + secondColorString[0] + secondColorString[1] + secondColorString[2] + "  vec4 color = texture2D(sTexture, vTextureCoord);\n" + "  float energy = (color.r + color.g + color.b) * 0.3333;\n" + "  vec3 new_color = (1.0 - energy) * first + energy * second;\n" + "  gl_FragColor = vec4(new_color.rgb, color.a);\n" + "}\n";
        return shader;
    }
}

