/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.Surface;
import com.danikula.videocache.CacheListener;
import com.danikula.videocache.HttpProxyCacheServer;
import com.danikula.videocache.file.Md5FileNameGenerator;
import com.danikula.videocache.headers.HeaderInjector;
import com.shuyu.gsyvideoplayer.listener.GSYMediaPlayerListener;
import com.shuyu.gsyvideoplayer.model.GSYModel;
import com.shuyu.gsyvideoplayer.model.VideoOptionModel;
import com.shuyu.gsyvideoplayer.player.EXO2PlayerManager;
import com.shuyu.gsyvideoplayer.player.IJKPlayerManager;
import com.shuyu.gsyvideoplayer.player.IPlayerManager;
import com.shuyu.gsyvideoplayer.player.SystemPlayerManager;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.FileUtils;
import com.shuyu.gsyvideoplayer.utils.StorageUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkLibLoader;

public class GSYVideoManager
implements IMediaPlayer.OnPreparedListener,
IMediaPlayer.OnCompletionListener,
IMediaPlayer.OnBufferingUpdateListener,
IMediaPlayer.OnSeekCompleteListener,
IMediaPlayer.OnErrorListener,
IMediaPlayer.OnVideoSizeChangedListener,
IMediaPlayer.OnInfoListener,
CacheListener {
    public static String TAG = "GSYVideoManager";
    @SuppressLint(value={"StaticFieldLeak"})
    private static GSYVideoManager videoManager;
    private static final int HANDLER_PREPARE = 0;
    private static final int HANDLER_SETDISPLAY = 1;
    private static final int HANDLER_RELEASE = 2;
    private static final int HANDLER_RELEASE_SURFACE = 3;
    private static final int BUFFER_TIME_OUT_ERROR = -192;
    private MediaHandler mMediaHandler;
    private Handler mainThreadHandler;
    private WeakReference<GSYMediaPlayerListener> listener;
    private WeakReference<GSYMediaPlayerListener> lastListener;
    private static IjkLibLoader ijkLibLoader;
    private List<VideoOptionModel> optionModelList;
    private HttpProxyCacheServer proxy;
    private File cacheFile;
    private String playTag = "";
    private Map<String, String> mMapHeadData;
    private Context context;
    private IPlayerManager playerManager;
    private int currentVideoWidth = 0;
    private int currentVideoHeight = 0;
    private int lastState;
    private int playPosition = -22;
    private int buffterPoint;
    private int timeOut = 8000;
    private int videoType = 0;
    private boolean needMute = false;
    private boolean needTimeOutOther;
    private Runnable mTimeOutRunnable = new Runnable(){

        @Override
        public void run() {
            if (GSYVideoManager.this.listener != null) {
                Debuger.printfError("time out for error listener");
                GSYVideoManager.this.listener().onError(-192, -192);
            }
        }
    };

    public static synchronized GSYVideoManager instance() {
        if (videoManager == null) {
            videoManager = new GSYVideoManager(ijkLibLoader);
        }
        return videoManager;
    }

    public static synchronized GSYVideoManager tmpInstance(GSYMediaPlayerListener listener) {
        GSYVideoManager gsyVideoManager = new GSYVideoManager(ijkLibLoader);
        gsyVideoManager.buffterPoint = GSYVideoManager.videoManager.buffterPoint;
        gsyVideoManager.optionModelList = GSYVideoManager.videoManager.optionModelList;
        gsyVideoManager.cacheFile = GSYVideoManager.videoManager.cacheFile;
        gsyVideoManager.playTag = GSYVideoManager.videoManager.playTag;
        gsyVideoManager.mMapHeadData = GSYVideoManager.videoManager.mMapHeadData;
        gsyVideoManager.currentVideoWidth = GSYVideoManager.videoManager.currentVideoWidth;
        gsyVideoManager.currentVideoHeight = GSYVideoManager.videoManager.currentVideoHeight;
        gsyVideoManager.context = GSYVideoManager.videoManager.context;
        gsyVideoManager.lastState = GSYVideoManager.videoManager.lastState;
        gsyVideoManager.playPosition = GSYVideoManager.videoManager.playPosition;
        gsyVideoManager.timeOut = GSYVideoManager.videoManager.timeOut;
        gsyVideoManager.videoType = GSYVideoManager.videoManager.videoType;
        gsyVideoManager.needMute = GSYVideoManager.videoManager.needMute;
        gsyVideoManager.needTimeOutOther = GSYVideoManager.videoManager.needTimeOutOther;
        gsyVideoManager.setListener(listener);
        return gsyVideoManager;
    }

    public static synchronized void changeManager(GSYVideoManager gsyVideoManager) {
        videoManager = gsyVideoManager;
    }

    public static void setIjkLibLoader(IjkLibLoader libLoader) {
        IJKPlayerManager.setIjkLibLoader(libLoader);
        ijkLibLoader = libLoader;
    }

    public static IjkLibLoader getIjkLibLoader() {
        return ijkLibLoader;
    }

    public static void clearAllDefaultCache(Context context) {
        String path = StorageUtils.getIndividualCacheDirectory(context.getApplicationContext()).getAbsolutePath();
        FileUtils.deleteFiles(new File(path));
    }

    public static void clearDefaultCache(Context context, String url) {
        Md5FileNameGenerator md5FileNameGenerator = new Md5FileNameGenerator();
        String name = md5FileNameGenerator.generate(url);
        String pathTmp = StorageUtils.getIndividualCacheDirectory(context.getApplicationContext()).getAbsolutePath() + File.separator + name + ".download";
        String path = StorageUtils.getIndividualCacheDirectory(context.getApplicationContext()).getAbsolutePath() + File.separator + name;
        CommonUtil.deleteFile(pathTmp);
        CommonUtil.deleteFile(path);
    }

    public static HttpProxyCacheServer getProxy(Context context, File file) {
        if (file == null) {
            return GSYVideoManager.getProxy(context);
        }
        if (GSYVideoManager.instance().cacheFile != null && !GSYVideoManager.instance().cacheFile.getAbsolutePath().equals(file.getAbsolutePath())) {
            HttpProxyCacheServer proxy = GSYVideoManager.instance().proxy;
            if (proxy != null) {
                proxy.shutdown();
            }
            GSYVideoManager.instance().proxy = GSYVideoManager.instance().newProxy(context, file);
            return GSYVideoManager.instance().proxy;
        }
        HttpProxyCacheServer proxy = GSYVideoManager.instance().proxy;
        return proxy == null ? (GSYVideoManager.instance().proxy = GSYVideoManager.instance().newProxy(context, file)) : proxy;
    }

    private static HttpProxyCacheServer getProxy(Context context) {
        HttpProxyCacheServer proxy = GSYVideoManager.instance().proxy;
        return proxy == null ? (GSYVideoManager.instance().proxy = GSYVideoManager.instance().newProxy(context)) : proxy;
    }

    public HttpProxyCacheServer newProxy(Context context, File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        HttpProxyCacheServer.Builder builder = new HttpProxyCacheServer.Builder(context);
        builder.cacheDirectory(file);
        builder.headerInjector((HeaderInjector)new UserAgentHeadersInjector());
        this.cacheFile = file;
        return builder.build();
    }

    public void setProxy(HttpProxyCacheServer proxy) {
        this.proxy = proxy;
    }

    public HttpProxyCacheServer newProxy(Context context) {
        return new HttpProxyCacheServer.Builder(context.getApplicationContext()).headerInjector((HeaderInjector)new UserAgentHeadersInjector()).build();
    }

    public GSYMediaPlayerListener listener() {
        if (this.listener == null) {
            return null;
        }
        return (GSYMediaPlayerListener)this.listener.get();
    }

    public GSYMediaPlayerListener lastListener() {
        if (this.lastListener == null) {
            return null;
        }
        return (GSYMediaPlayerListener)this.lastListener.get();
    }

    public void setListener(GSYMediaPlayerListener listener) {
        this.listener = listener == null ? null : new WeakReference<GSYMediaPlayerListener>(listener);
    }

    public void setLastListener(GSYMediaPlayerListener lastListener) {
        this.lastListener = lastListener == null ? null : new WeakReference<GSYMediaPlayerListener>(lastListener);
    }

    private GSYVideoManager(IjkLibLoader libLoader) {
        this.playerManager = GSYVideoManager.getPlayManager(0);
        ijkLibLoader = libLoader;
        IJKPlayerManager.setIjkLibLoader(ijkLibLoader);
        HandlerThread mediaHandlerThread = new HandlerThread(TAG);
        mediaHandlerThread.start();
        this.mMediaHandler = new MediaHandler(mediaHandlerThread.getLooper());
        this.mainThreadHandler = new Handler();
    }

    private void initVideo(Message msg) {
        try {
            this.currentVideoWidth = 0;
            this.currentVideoHeight = 0;
            if (this.playerManager != null) {
                this.playerManager.release();
            }
            this.playerManager = GSYVideoManager.getPlayManager(this.videoType);
            this.playerManager.initVideoPlayer(this.context, msg, this.optionModelList);
            this.setNeedMute(this.needMute);
            IMediaPlayer mediaPlayer = this.playerManager.getMediaPlayer();
            mediaPlayer.setOnCompletionListener((IMediaPlayer.OnCompletionListener)this);
            mediaPlayer.setOnBufferingUpdateListener((IMediaPlayer.OnBufferingUpdateListener)this);
            mediaPlayer.setScreenOnWhilePlaying(true);
            mediaPlayer.setOnPreparedListener((IMediaPlayer.OnPreparedListener)this);
            mediaPlayer.setOnSeekCompleteListener((IMediaPlayer.OnSeekCompleteListener)this);
            mediaPlayer.setOnErrorListener((IMediaPlayer.OnErrorListener)this);
            mediaPlayer.setOnInfoListener((IMediaPlayer.OnInfoListener)this);
            mediaPlayer.setOnVideoSizeChangedListener((IMediaPlayer.OnVideoSizeChangedListener)this);
            mediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startTimeOutBuffer() {
        Debuger.printfError("startTimeOutBuffer");
        this.mainThreadHandler.postDelayed(this.mTimeOutRunnable, (long)this.timeOut);
    }

    private void cancelTimeOutBuffer() {
        Debuger.printfError("cancelTimeOutBuffer");
        if (this.needTimeOutOther) {
            this.mainThreadHandler.removeCallbacks(this.mTimeOutRunnable);
        }
    }

    private void releaseSurface(Message msg) {
        if (msg.obj != null && this.playerManager != null) {
            this.playerManager.releaseSurface();
        }
    }

    private void showDisplay(Message msg) {
        if (this.playerManager != null) {
            this.playerManager.showDisplay(msg);
        }
    }

    public void setSpeed(float speed, boolean soundTouch) {
        if (this.playerManager != null) {
            this.playerManager.setSpeed(speed, soundTouch);
        }
    }

    public void prepare(String url, Map<String, String> mapHeadData, boolean loop, float speed) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        Message msg = new Message();
        msg.what = 0;
        this.mMapHeadData = mapHeadData;
        GSYModel fb = new GSYModel(url, mapHeadData, loop, speed);
        msg.obj = fb;
        this.mMediaHandler.sendMessage(msg);
        if (this.needTimeOutOther) {
            this.startTimeOutBuffer();
        }
    }

    public void releaseMediaPlayer() {
        Message msg = new Message();
        msg.what = 2;
        this.mMediaHandler.sendMessage(msg);
        this.playTag = "";
        this.playPosition = -22;
    }

    public void setDisplay(Surface holder) {
        Message msg = new Message();
        msg.what = 1;
        msg.obj = holder;
        this.mMediaHandler.sendMessage(msg);
    }

    public void releaseSurface(Surface holder) {
        Message msg = new Message();
        msg.what = 3;
        msg.obj = holder;
        this.mMediaHandler.sendMessage(msg);
    }

    public void onPrepared(IMediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                GSYVideoManager.this.cancelTimeOutBuffer();
                if (GSYVideoManager.this.listener != null) {
                    GSYVideoManager.this.listener().onPrepared();
                }
            }
        });
    }

    public void onCompletion(IMediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                GSYVideoManager.this.cancelTimeOutBuffer();
                if (GSYVideoManager.this.listener != null) {
                    GSYVideoManager.this.listener().onAutoCompletion();
                }
            }
        });
    }

    public void onBufferingUpdate(IMediaPlayer mp, final int percent) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GSYVideoManager.this.listener != null) {
                    if (percent > GSYVideoManager.this.buffterPoint) {
                        GSYVideoManager.this.listener().onBufferingUpdate(percent);
                    } else {
                        GSYVideoManager.this.listener().onBufferingUpdate(GSYVideoManager.this.buffterPoint);
                    }
                }
            }
        });
    }

    public void onSeekComplete(IMediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                GSYVideoManager.this.cancelTimeOutBuffer();
                if (GSYVideoManager.this.listener != null) {
                    GSYVideoManager.this.listener().onSeekComplete();
                }
            }
        });
    }

    public boolean onError(IMediaPlayer mp, final int what, final int extra) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                GSYVideoManager.this.cancelTimeOutBuffer();
                if (GSYVideoManager.this.listener != null) {
                    GSYVideoManager.this.listener().onError(what, extra);
                }
            }
        });
        return true;
    }

    public boolean onInfo(IMediaPlayer mp, final int what, final int extra) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GSYVideoManager.this.needTimeOutOther) {
                    if (what == 701) {
                        GSYVideoManager.this.startTimeOutBuffer();
                    } else if (what == 702) {
                        GSYVideoManager.this.cancelTimeOutBuffer();
                    }
                }
                if (GSYVideoManager.this.listener != null) {
                    GSYVideoManager.this.listener().onInfo(what, extra);
                }
            }
        });
        return false;
    }

    public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sar_num, int sar_den) {
        this.currentVideoWidth = mp.getVideoWidth();
        this.currentVideoHeight = mp.getVideoHeight();
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GSYVideoManager.this.listener != null) {
                    GSYVideoManager.this.listener().onVideoSizeChanged();
                }
            }
        });
    }

    public void onCacheAvailable(File cacheFile, String url, int percentsAvailable) {
        this.buffterPoint = percentsAvailable;
    }

    public static void onPause() {
        if (GSYVideoManager.instance().listener() != null) {
            GSYVideoManager.instance().listener().onVideoPause();
        }
    }

    public static void onResume() {
        if (GSYVideoManager.instance().listener() != null) {
            GSYVideoManager.instance().listener().onVideoResume();
        }
    }

    public IMediaPlayer getMediaPlayer() {
        if (this.playerManager != null) {
            return this.playerManager.getMediaPlayer();
        }
        return null;
    }

    public int getVideoType() {
        return this.videoType;
    }

    public void setVideoType(Context context, int videoType) {
        this.context = context.getApplicationContext();
        this.videoType = videoType;
    }

    private static IPlayerManager getPlayManager(int videoType) {
        switch (videoType) {
            case 2: {
                return new EXO2PlayerManager();
            }
            case 4: {
                return new SystemPlayerManager();
            }
        }
        return new IJKPlayerManager();
    }

    public int getCurrentVideoWidth() {
        return this.currentVideoWidth;
    }

    public int getCurrentVideoHeight() {
        return this.currentVideoHeight;
    }

    public int getLastState() {
        return this.lastState;
    }

    public void setLastState(int lastState) {
        this.lastState = lastState;
    }

    public void setCurrentVideoHeight(int currentVideoHeight) {
        this.currentVideoHeight = currentVideoHeight;
    }

    public void setCurrentVideoWidth(int currentVideoWidth) {
        this.currentVideoWidth = currentVideoWidth;
    }

    public String getPlayTag() {
        return this.playTag;
    }

    public void setPlayTag(String playTag) {
        this.playTag = playTag;
    }

    public int getPlayPosition() {
        return this.playPosition;
    }

    public void setPlayPosition(int playPosition) {
        this.playPosition = playPosition;
    }

    public List<VideoOptionModel> getOptionModelList() {
        return this.optionModelList;
    }

    public void setOptionModelList(List<VideoOptionModel> optionModelList) {
        this.optionModelList = optionModelList;
    }

    public boolean isNeedMute() {
        return this.needMute;
    }

    public void setNeedMute(boolean needMute) {
        this.needMute = needMute;
        if (this.playerManager != null) {
            this.playerManager.setNeedMute(needMute);
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public boolean isNeedTimeOutOther() {
        return this.needTimeOutOther;
    }

    public void setTimeOut(int timeOut, boolean needTimeOutOther) {
        this.timeOut = timeOut;
        this.needTimeOutOther = needTimeOutOther;
    }

    public void setLogLevel(int logLevel) {
        IJKPlayerManager.setLogLevel(logLevel);
    }

    private class UserAgentHeadersInjector
    implements HeaderInjector {
        private UserAgentHeadersInjector() {
        }

        public Map<String, String> addHeaders(String url) {
            return GSYVideoManager.this.mMapHeadData;
        }
    }

    private class MediaHandler
    extends Handler {
        MediaHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    GSYVideoManager.this.initVideo(msg);
                    break;
                }
                case 1: {
                    GSYVideoManager.this.showDisplay(msg);
                    break;
                }
                case 2: {
                    if (GSYVideoManager.this.playerManager != null) {
                        GSYVideoManager.this.playerManager.release();
                    }
                    GSYVideoManager.this.setNeedMute(false);
                    if (GSYVideoManager.this.proxy != null) {
                        GSYVideoManager.this.proxy.unregisterCacheListener((CacheListener)GSYVideoManager.this);
                    }
                    GSYVideoManager.this.buffterPoint = 0;
                    GSYVideoManager.this.cancelTimeOutBuffer();
                    break;
                }
                case 3: {
                    GSYVideoManager.this.releaseSurface(msg);
                }
            }
        }
    }
}

