/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.View;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.effect.NoEffect;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotListener;
import com.shuyu.gsyvideoplayer.render.GSYVideoGLViewBaseRender;
import com.shuyu.gsyvideoplayer.render.GSYVideoGLViewSimpleRender;
import com.shuyu.gsyvideoplayer.utils.MeasureHelper;

@SuppressLint(value={"ViewConstructor"})
public class GSYVideoGLView
extends GLSurfaceView {
    private static final String TAG = GSYVideoGLView.class.getName();
    private GSYVideoGLViewBaseRender mRenderer;
    private Context mContext;
    private ShaderInterface mEffect = new NoEffect();
    private float[] mMVPMatrix;
    private MeasureHelper measureHelper;
    private onGSYSurfaceListener mGSYSurfaceListener;

    public GSYVideoGLView(Context context) {
        super(context);
        this.init(context);
    }

    public GSYVideoGLView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.setEGLContextClientVersion(2);
        this.mRenderer = new GSYVideoGLViewSimpleRender();
        this.measureHelper = new MeasureHelper((View)this);
        this.mRenderer.setSurfaceView(this);
    }

    public void initRender() {
        this.setRenderer(this.mRenderer);
    }

    public void setCustomRenderer(GSYVideoGLViewBaseRender CustomRender) {
        this.mRenderer = CustomRender;
        this.mRenderer.setSurfaceView(this);
    }

    public void setGSYSurfaceListener(onGSYSurfaceListener mGSYSurfaceListener) {
        this.mGSYSurfaceListener = mGSYSurfaceListener;
        this.mRenderer.setGSYSurfaceListener(this.mGSYSurfaceListener);
    }

    public void setEffect(ShaderInterface shaderEffect) {
        if (shaderEffect != null) {
            this.mEffect = shaderEffect;
            this.mRenderer.setEffect(this.mEffect);
        }
    }

    public void setMVPMatrix(float[] MVPMatrix) {
        if (MVPMatrix != null) {
            this.mMVPMatrix = MVPMatrix;
            this.mRenderer.setMVPMatrix(MVPMatrix);
        }
    }

    public void takeShotPic() {
        this.mRenderer.takeShotPic();
    }

    public void setGSYVideoShotListener(GSYVideoShotListener listener, boolean high) {
        this.mRenderer.setGSYVideoShotListener(listener, high);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (GSYVideoManager.instance().getMediaPlayer() != null) {
            try {
                int videoWidth = GSYVideoManager.instance().getCurrentVideoWidth();
                int videoHeight = GSYVideoManager.instance().getCurrentVideoHeight();
                int videoSarNum = GSYVideoManager.instance().getMediaPlayer().getVideoSarNum();
                int videoSarDen = GSYVideoManager.instance().getMediaPlayer().getVideoSarDen();
                if (videoWidth > 0 && videoHeight > 0) {
                    this.measureHelper.setVideoSampleAspectRatio(videoSarNum, videoSarDen);
                    this.measureHelper.setVideoSize(videoWidth, videoHeight);
                }
                this.measureHelper.setVideoRotation((int)this.getRotation());
                this.measureHelper.doMeasure(widthMeasureSpec, heightMeasureSpec);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setMeasuredDimension(this.measureHelper.getMeasuredWidth(), this.measureHelper.getMeasuredHeight());
    }

    public int getSizeH() {
        return this.measureHelper.getMeasuredHeight();
    }

    public int getSizeW() {
        return this.measureHelper.getMeasuredWidth();
    }

    public void releaseAll() {
        if (this.mRenderer != null) {
            this.mRenderer.releaseAll();
        }
    }

    public static interface ShaderInterface {
        public String getShader(GLSurfaceView var1);
    }

    public static interface onGSYSurfaceListener {
        public void onSurfaceAvailable(Surface var1);
    }
}

