/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.View;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.effect.NoEffect;
import com.shuyu.gsyvideoplayer.utils.MeasureHelper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

@SuppressLint(value={"ViewConstructor"})
public class GSYVideoGLView
extends GLSurfaceView {
    private static final String TAG = GSYVideoGLView.class.getName();
    private VideoRender mRenderer;
    private Context mContext;
    private ShaderInterface mEffect = new NoEffect();
    private MeasureHelper measureHelper;
    private onGSYSurfaceListener mGSYSurfaceListener;

    public GSYVideoGLView(Context context) {
        super(context);
        this.init(context);
    }

    public GSYVideoGLView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.setEGLContextClientVersion(2);
        this.mRenderer = new VideoRender();
        this.measureHelper = new MeasureHelper((View)this);
        this.setRenderer(this.mRenderer);
        this.mRenderer.setSurfaceView(this);
    }

    public void setGSYSurfaceListener(onGSYSurfaceListener mGSYSurfaceListener) {
        this.mGSYSurfaceListener = mGSYSurfaceListener;
        this.mRenderer.setGSYSurfaceListener(this.mGSYSurfaceListener);
    }

    public void setEffect(ShaderInterface shaderEffect) {
        if (shaderEffect != null) {
            this.mEffect = shaderEffect;
            this.mRenderer.setEffect(this.mEffect);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (GSYVideoManager.instance().getMediaPlayer() != null) {
            try {
                int videoWidth = GSYVideoManager.instance().getCurrentVideoWidth();
                int videoHeight = GSYVideoManager.instance().getCurrentVideoHeight();
                int videoSarNum = GSYVideoManager.instance().getMediaPlayer().getVideoSarNum();
                int videoSarDen = GSYVideoManager.instance().getMediaPlayer().getVideoSarDen();
                if (videoWidth > 0 && videoHeight > 0) {
                    this.measureHelper.setVideoSampleAspectRatio(videoSarNum, videoSarDen);
                    this.measureHelper.setVideoSize(videoWidth, videoHeight);
                }
                this.measureHelper.setVideoRotation((int)this.getRotation());
                this.measureHelper.doMeasure(widthMeasureSpec, heightMeasureSpec);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setMeasuredDimension(this.measureHelper.getMeasuredWidth(), this.measureHelper.getMeasuredHeight());
    }

    public int getSizeH() {
        return this.measureHelper.getMeasuredHeight();
    }

    public int getSizeW() {
        return this.measureHelper.getMeasuredWidth();
    }

    private static class VideoRender
    implements GLSurfaceView.Renderer,
    SurfaceTexture.OnFrameAvailableListener {
        private static String TAG = VideoRender.class.getName();
        private static final int FLOAT_SIZE_BYTES = 4;
        private static final int TRIANGLE_VERTICES_DATA_STRIDE_BYTES = 20;
        private static final int TRIANGLE_VERTICES_DATA_POS_OFFSET = 0;
        private static final int TRIANGLE_VERTICES_DATA_UV_OFFSET = 3;
        private static final int GL_TEXTURE_EXTERNAL_OES = 36197;
        private final float[] mTriangleVerticesData = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        private FloatBuffer mTriangleVertices;
        private final String mVertexShader = "uniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = (uSTMatrix * aTextureCoord).xy;\n}\n";
        private float[] mMVPMatrix = new float[16];
        private float[] mSTMatrix = new float[16];
        private int mProgram;
        private int[] mTextureID = new int[2];
        private int muMVPMatrixHandle;
        private int muSTMatrixHandle;
        private int maPositionHandle;
        private int maTextureHandle;
        private boolean updateSurface = false;
        private SurfaceTexture mSurface;
        private onGSYSurfaceListener mGSYSurfaceListener;
        private ShaderInterface mEffect = new NoEffect();
        private GLSurfaceView mSurfaceView;

        public void setEffect(ShaderInterface shaderEffect) {
            if (shaderEffect != null) {
                this.mEffect = shaderEffect;
            }
        }

        public VideoRender() {
            this.mTriangleVertices = ByteBuffer.allocateDirect(this.mTriangleVerticesData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.mTriangleVertices.put(this.mTriangleVerticesData).position(0);
            Matrix.setIdentityM((float[])this.mSTMatrix, (int)0);
        }

        public void setGSYSurfaceListener(onGSYSurfaceListener onSurfaceListener) {
            this.mGSYSurfaceListener = onSurfaceListener;
        }

        public void setSurfaceView(GLSurfaceView surfaceView) {
            this.mSurfaceView = surfaceView;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDrawFrame(GL10 glUnused) {
            VideoRender videoRender = this;
            synchronized (videoRender) {
                if (this.updateSurface) {
                    this.mSurface.updateTexImage();
                    this.mSurface.getTransformMatrix(this.mSTMatrix);
                    this.updateSurface = false;
                }
            }
            this.mProgram = this.createProgram("uniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = (uSTMatrix * aTextureCoord).xy;\n}\n", this.mEffect.getShader(this.mSurfaceView));
            GLES20.glClearColor((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            GLES20.glClear((int)16640);
            GLES20.glUseProgram((int)this.mProgram);
            this.checkGlError("glUseProgram");
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)36197, (int)this.mTextureID[0]);
            this.mTriangleVertices.position(0);
            GLES20.glVertexAttribPointer((int)this.maPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.mTriangleVertices);
            this.checkGlError("glVertexAttribPointer maPosition");
            GLES20.glEnableVertexAttribArray((int)this.maPositionHandle);
            this.checkGlError("glEnableVertexAttribArray maPositionHandle");
            this.mTriangleVertices.position(3);
            GLES20.glVertexAttribPointer((int)this.maTextureHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.mTriangleVertices);
            this.checkGlError("glVertexAttribPointer maTextureHandle");
            GLES20.glEnableVertexAttribArray((int)this.maTextureHandle);
            this.checkGlError("glEnableVertexAttribArray maTextureHandle");
            Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
            GLES20.glUniformMatrix4fv((int)this.muMVPMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
            GLES20.glUniformMatrix4fv((int)this.muSTMatrixHandle, (int)1, (boolean)false, (float[])this.mSTMatrix, (int)0);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            this.checkGlError("glDrawArrays");
            GLES20.glFinish();
        }

        public void onSurfaceChanged(GL10 glUnused, int width, int height) {
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        }

        public void onSurfaceCreated(GL10 glUnused, EGLConfig config) {
            this.mProgram = this.createProgram("uniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = (uSTMatrix * aTextureCoord).xy;\n}\n", this.mEffect.getShader(this.mSurfaceView));
            if (this.mProgram == 0) {
                return;
            }
            this.maPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aPosition");
            this.checkGlError("glGetAttribLocation aPosition");
            if (this.maPositionHandle == -1) {
                throw new RuntimeException("Could not get attrib location for aPosition");
            }
            this.maTextureHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTextureCoord");
            this.checkGlError("glGetAttribLocation aTextureCoord");
            if (this.maTextureHandle == -1) {
                throw new RuntimeException("Could not get attrib location for aTextureCoord");
            }
            this.muMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uMVPMatrix");
            this.checkGlError("glGetUniformLocation uMVPMatrix");
            if (this.muMVPMatrixHandle == -1) {
                throw new RuntimeException("Could not get attrib location for uMVPMatrix");
            }
            this.muSTMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uSTMatrix");
            this.checkGlError("glGetUniformLocation uSTMatrix");
            if (this.muSTMatrixHandle == -1) {
                throw new RuntimeException("Could not get attrib location for uSTMatrix");
            }
            GLES20.glGenTextures((int)2, (int[])this.mTextureID, (int)0);
            GLES20.glBindTexture((int)36197, (int)this.mTextureID[0]);
            this.checkGlError("glBindTexture mTextureID");
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            this.mSurface = new SurfaceTexture(this.mTextureID[0]);
            this.mSurface.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            Surface surface = new Surface(this.mSurface);
            if (this.mGSYSurfaceListener != null) {
                this.mGSYSurfaceListener.onSurfaceAvailable(surface);
            }
        }

        public synchronized void onFrameAvailable(SurfaceTexture surface) {
            this.updateSurface = true;
        }

        private int loadShader(int shaderType, String source) {
            int shader = GLES20.glCreateShader((int)shaderType);
            if (shader != 0) {
                GLES20.glShaderSource((int)shader, (String)source);
                GLES20.glCompileShader((int)shader);
                int[] compiled = new int[1];
                GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
                if (compiled[0] == 0) {
                    Log.e((String)TAG, (String)("Could not compile shader " + shaderType + ":"));
                    Log.e((String)TAG, (String)GLES20.glGetShaderInfoLog((int)shader));
                    GLES20.glDeleteShader((int)shader);
                    shader = 0;
                }
            }
            return shader;
        }

        private int createProgram(String vertexSource, String fragmentSource) {
            int vertexShader = this.loadShader(35633, vertexSource);
            if (vertexShader == 0) {
                return 0;
            }
            int pixelShader = this.loadShader(35632, fragmentSource);
            if (pixelShader == 0) {
                return 0;
            }
            int program = GLES20.glCreateProgram();
            if (program != 0) {
                GLES20.glAttachShader((int)program, (int)vertexShader);
                this.checkGlError("glAttachShader");
                GLES20.glAttachShader((int)program, (int)pixelShader);
                this.checkGlError("glAttachShader");
                GLES20.glLinkProgram((int)program);
                int[] linkStatus = new int[1];
                GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
                if (linkStatus[0] != 1) {
                    Log.e((String)TAG, (String)"Could not link program: ");
                    Log.e((String)TAG, (String)GLES20.glGetProgramInfoLog((int)program));
                    GLES20.glDeleteProgram((int)program);
                    program = 0;
                }
            }
            return program;
        }

        private void checkGlError(String op) {
            int error = GLES20.glGetError();
            if (error != 0) {
                Log.e((String)TAG, (String)(op + ": glError " + error));
                throw new RuntimeException(op + ": glError " + error);
            }
        }
    }

    public static interface ShaderInterface {
        public String getShader(GLSurfaceView var1);
    }

    public static interface onGSYSurfaceListener {
        public void onSurfaceAvailable(Surface var1);
    }
}

