/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.utils.MeasureHelper;

public class GSYSurfaceView
extends SurfaceView {
    private MeasureHelper measureHelper;

    public GSYSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public GSYSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.measureHelper = new MeasureHelper((View)this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int videoWidth = GSYVideoManager.instance().getCurrentVideoWidth();
        int videoHeight = GSYVideoManager.instance().getCurrentVideoHeight();
        int videoSarNum = GSYVideoManager.instance().getMediaPlayer().getVideoSarNum();
        int videoSarDen = GSYVideoManager.instance().getMediaPlayer().getVideoSarDen();
        if (videoWidth > 0 && videoHeight > 0) {
            this.measureHelper.setVideoSampleAspectRatio(videoSarNum, videoSarDen);
            this.measureHelper.setVideoSize(videoWidth, videoHeight);
        }
        this.measureHelper.setVideoRotation((int)this.getRotation());
        this.measureHelper.doMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.measureHelper.getMeasuredWidth(), this.measureHelper.getMeasuredHeight());
    }

    public int getSizeH() {
        return this.measureHelper.getMeasuredHeight();
    }

    public int getSizeW() {
        return this.measureHelper.getMeasuredWidth();
    }
}

