/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.sensorsdata.analytics.android.sdk.SALog;

public class Dispatcher {
    private static final String TAG = Dispatcher.class.getSimpleName();
    private final Handler mHandler;
    private Handler mUiThreadHandler;

    public static Dispatcher getInstance() {
        return DispatchHolder.INSTANCE;
    }

    private Dispatcher() {
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
    }

    public void post(Runnable r) {
        this.postDelayed(r, 0L);
    }

    public void postDelayed(Runnable r, long delayMillis) {
        this.mHandler.removeCallbacks(r);
        this.mHandler.postDelayed(r, delayMillis);
    }

    public void removeCallbacksAndMessages() {
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public synchronized Handler getUiThreadHandler() {
        try {
            if (this.mUiThreadHandler == null) {
                this.mUiThreadHandler = new Handler(Looper.getMainLooper());
            }
            return this.mUiThreadHandler;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return null;
        }
    }

    private static class DispatchHolder {
        private static final Dispatcher INSTANCE = new Dispatcher();

        private DispatchHolder() {
        }
    }
}

