/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.data.persistent;

import android.content.Context;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.data.persistent.LoginIdKeyPersistent;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentAppEndData;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentAppExitData;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentDailyDate;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentDistinctId;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentFirstDay;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentFirstStart;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentFirstTrackInstallation;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentFirstTrackInstallationWithCallback;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentIdentity;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoginId;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentRemoteSDKConfig;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentSuperProperties;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentVisualConfig;
import com.sensorsdata.analytics.android.sdk.data.persistent.UserIdentityPersistent;

public class PersistentLoader {
    private final Context mContext;
    private static volatile PersistentLoader INSTANCE;
    private final PersistentAppEndData mAppEndDataPst;
    private final PersistentAppExitData mAppExitDataPst;
    private final PersistentLoginId mLoginIdPst;
    private final PersistentDistinctId mAnonymousIdPst;
    private final PersistentRemoteSDKConfig mRemoteSDKConfig;
    private final LoginIdKeyPersistent mLoginIdKeyPst;
    private final UserIdentityPersistent mUserIdsPst;
    private final PersistentFirstStart mFirstStartPst;
    private final PersistentFirstDay mFirstDayPst;
    private final PersistentDailyDate mDayDatePst;
    private final PersistentSuperProperties mSuperPropertiesPst;
    private final PersistentVisualConfig mVisualConfigPst;
    private final PersistentFirstTrackInstallation mFirstInstallationPst;
    private final PersistentFirstTrackInstallationWithCallback mFirstInstallationWithCallbackPst;

    private PersistentLoader(Context context) {
        this.mContext = context.getApplicationContext();
        this.mAppEndDataPst = (PersistentAppEndData)this.loadPersistent("app_end_data");
        this.mAppExitDataPst = (PersistentAppExitData)this.loadPersistent("app_exit_data");
        this.mLoginIdPst = (PersistentLoginId)this.loadPersistent("events_login_id");
        this.mRemoteSDKConfig = (PersistentRemoteSDKConfig)this.loadPersistent("sensorsdata_sdk_configuration");
        this.mUserIdsPst = (UserIdentityPersistent)this.loadPersistent("user_ids");
        this.mLoginIdKeyPst = (LoginIdKeyPersistent)this.loadPersistent("login_id_key");
        this.mAnonymousIdPst = (PersistentDistinctId)this.loadPersistent("events_distinct_id");
        this.mFirstStartPst = (PersistentFirstStart)this.loadPersistent("first_start");
        this.mFirstDayPst = (PersistentFirstDay)this.loadPersistent("first_day");
        this.mSuperPropertiesPst = (PersistentSuperProperties)this.loadPersistent("super_properties");
        this.mVisualConfigPst = (PersistentVisualConfig)this.loadPersistent("visual_properties");
        this.mFirstInstallationPst = (PersistentFirstTrackInstallation)this.loadPersistent("first_track_installation");
        this.mFirstInstallationWithCallbackPst = (PersistentFirstTrackInstallationWithCallback)this.loadPersistent("first_track_installation_with_callback");
        this.mDayDatePst = (PersistentDailyDate)this.loadPersistent("daily_date");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void preInit(Context context) {
        if (INSTANCE != null) return;
        Class<PersistentLoader> clazz = PersistentLoader.class;
        synchronized (PersistentLoader.class) {
            if (INSTANCE != null) return;
            INSTANCE = new PersistentLoader(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static PersistentLoader getInstance() {
        return INSTANCE;
    }

    private PersistentIdentity<?> loadPersistent(String persistentKey) {
        if (TextUtils.isEmpty((CharSequence)persistentKey)) {
            return null;
        }
        switch (persistentKey) {
            case "app_end_data": {
                return new PersistentAppEndData();
            }
            case "events_distinct_id": {
                return new PersistentDistinctId(this.mContext);
            }
            case "first_day": {
                return new PersistentFirstDay();
            }
            case "first_track_installation": {
                return new PersistentFirstTrackInstallation();
            }
            case "first_track_installation_with_callback": {
                return new PersistentFirstTrackInstallationWithCallback();
            }
            case "first_start": {
                return new PersistentFirstStart();
            }
            case "events_login_id": {
                return new PersistentLoginId();
            }
            case "sensorsdata_sdk_configuration": {
                return new PersistentRemoteSDKConfig();
            }
            case "super_properties": {
                return new PersistentSuperProperties();
            }
            case "visual_properties": {
                return new PersistentVisualConfig();
            }
            case "user_ids": {
                return new UserIdentityPersistent();
            }
            case "login_id_key": {
                return new LoginIdKeyPersistent();
            }
            case "app_exit_data": {
                return new PersistentAppExitData();
            }
            case "daily_date": {
                return new PersistentDailyDate();
            }
        }
        return null;
    }

    public PersistentAppEndData getAppEndDataPst() {
        return this.mAppEndDataPst;
    }

    public PersistentAppExitData getAppExitDataPst() {
        return this.mAppExitDataPst;
    }

    public PersistentLoginId getLoginIdPst() {
        return this.mLoginIdPst;
    }

    public PersistentDistinctId getAnonymousIdPst() {
        return this.mAnonymousIdPst;
    }

    public PersistentRemoteSDKConfig getRemoteSDKConfig() {
        return this.mRemoteSDKConfig;
    }

    public LoginIdKeyPersistent getLoginIdKeyPst() {
        return this.mLoginIdKeyPst;
    }

    public UserIdentityPersistent getUserIdsPst() {
        return this.mUserIdsPst;
    }

    public PersistentFirstStart getFirstStartPst() {
        return this.mFirstStartPst;
    }

    public PersistentFirstDay getFirstDayPst() {
        return this.mFirstDayPst;
    }

    public PersistentSuperProperties getSuperPropertiesPst() {
        return this.mSuperPropertiesPst;
    }

    public PersistentVisualConfig getVisualConfigPst() {
        return this.mVisualConfigPst;
    }

    public PersistentFirstTrackInstallation getFirstInstallationPst() {
        return this.mFirstInstallationPst;
    }

    public PersistentFirstTrackInstallationWithCallback getFirstInstallationWithCallbackPst() {
        return this.mFirstInstallationWithCallbackPst;
    }

    public PersistentDailyDate getDayDatePst() {
        return this.mDayDatePst;
    }
}

