/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.rpc;

import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPIEmptyImplementation;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbAdapter;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbParams;

public class SensorsDataContentObserver
extends ContentObserver {
    public SensorsDataContentObserver() {
        super(new Handler(Looper.getMainLooper()));
    }

    public void onChange(boolean selfChange, Uri uri) {
        try {
            if (DbParams.getInstance().getSessionTimeUri().equals((Object)uri)) {
                SensorsDataAPI.sharedInstance().setSessionIntervalTime(DbAdapter.getInstance().getSessionIntervalTime());
            } else if (DbParams.getInstance().getLoginIdUri().equals((Object)uri)) {
                String loginIDKey = DbAdapter.getInstance().getLoginIdKey();
                String loginID = DbAdapter.getInstance().getLoginId();
                boolean flag = TextUtils.isEmpty((CharSequence)loginID) || loginIDKey.equals("$identity_login_id");
                boolean bl = flag = flag && TextUtils.isEmpty((CharSequence)loginID);
                if (flag) {
                    if (State.LOGOUT.isDid) {
                        State.LOGOUT.isDid = false;
                        return;
                    }
                    State.LOGOUT.isObserverCalled = true;
                    SensorsDataAPI.sharedInstance().logout();
                } else {
                    if (State.LOGIN.isDid) {
                        State.LOGIN.isDid = false;
                        return;
                    }
                    SensorsDataAPI.sharedInstance().loginWithKey(loginIDKey, loginID);
                }
            } else if (DbParams.getInstance().getDisableSDKUri().equals((Object)uri)) {
                if (State.DISABLE_SDK.isDid) {
                    State.DISABLE_SDK.isDid = false;
                    return;
                }
                State.DISABLE_SDK.isObserverCalled = true;
                SensorsDataAPI.disableSDK();
            } else if (DbParams.getInstance().getEnableSDKUri().equals((Object)uri)) {
                if (State.ENABLE_SDK.isDid) {
                    State.ENABLE_SDK.isDid = false;
                    return;
                }
                State.ENABLE_SDK.isObserverCalled = true;
                SensorsDataAPI.enableSDK();
            } else if (DbParams.getInstance().getUserIdentities().equals((Object)uri)) {
                SensorsDataAPI sensorsDataAPI = SensorsDataAPI.sharedInstance();
                if (sensorsDataAPI instanceof SensorsDataAPIEmptyImplementation) {
                    return;
                }
                SAContextManager saContextManager = sensorsDataAPI.getSAContextManager();
                if (saContextManager != null) {
                    saContextManager.getUserIdentityAPI().getIdentitiesInstance().updateIdentities();
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static enum State {
        LOGOUT(false, false),
        LOGIN(false, false),
        ENABLE_SDK(false, false),
        DISABLE_SDK(false, false);

        public boolean isDid;
        public boolean isObserverCalled;

        private State(boolean isInterfaceDid, boolean isObserverCalled) {
            this.isDid = isInterfaceDid;
            this.isObserverCalled = isObserverCalled;
        }
    }
}

