/*
 * Created by dengshiwei on 2025/01/16.
 * Copyright 2015－2023 Sensors Data Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sensorsdata.analytics.android.autotrack.aop;

import com.sensorsdata.analytics.android.sdk.SALog;

import java.util.concurrent.CopyOnWriteArraySet;

public class AppAopHelper {
    // Fragment 的回调监听
    private static final CopyOnWriteArraySet<AppStateListener> APP_CALLBACKS = new CopyOnWriteArraySet<>();

    public static void onAppExit() {
        for (AppStateListener appStateListener : APP_CALLBACKS) {
            try {
                appStateListener.onAppExit();
            } catch (Exception e) {
                SALog.printStackTrace(e);
            }
        }
    }

    public static void addAppListener(AppStateListener appStateListener) {
        if (appStateListener == null) {
            return;
        }
        APP_CALLBACKS.add(appStateListener);
    }

    public static void removeAppListener(AppStateListener appStateListener) {
        if (appStateListener == null) {
            return;
        }
        APP_CALLBACKS.remove(appStateListener);
    }

    public interface AppStateListener {
        void onAppExit();
    }
}
