/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.perception.sensor;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.sdk.base.time.StampedData;

public class UwbEvent
implements StampedData,
Parcelable {
    private final long timestamp;
    private final int id;
    private final float direction;
    private final float distance;
    private final float confidence;
    public static final Parcelable.Creator<UwbEvent> CREATOR = new Parcelable.Creator<UwbEvent>(){

        public UwbEvent createFromParcel(Parcel in) {
            return new UwbEvent(in);
        }

        public UwbEvent[] newArray(int size) {
            return new UwbEvent[size];
        }
    };

    public UwbEvent(long timestamp, int id, int direction, int distance, int confidence) {
        this.timestamp = timestamp;
        this.id = id;
        this.direction = (float)Math.toRadians(-direction / 10);
        this.distance = (float)distance / 1000.0f;
        this.confidence = confidence;
    }

    public UwbEvent(int direction, int distance, int confidence) {
        this.timestamp = System.currentTimeMillis();
        this.id = 0;
        this.direction = (float)Math.toRadians(-direction / 10);
        this.distance = (float)distance / 1000.0f;
        this.confidence = confidence;
    }

    protected UwbEvent(Parcel in) {
        this.timestamp = in.readLong();
        this.id = in.readInt();
        this.direction = in.readFloat();
        this.distance = in.readFloat();
        this.confidence = in.readFloat();
    }

    public float getDirection() {
        return this.direction;
    }

    public float getDistance() {
        return this.distance;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return "UwbEvent: timestamp=" + this.timestamp + " id=" + this.id + " direction=" + this.direction + " distance=" + this.distance + " confidence=" + this.confidence;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.timestamp);
        dest.writeInt(this.id);
        dest.writeFloat(this.direction);
        dest.writeFloat(this.distance);
        dest.writeFloat(this.confidence);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long diff(StampedData source) {
        return source.getTimestamp() - this.timestamp;
    }
}

