package com.segway.robot.sdk.perception.sensor;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.base.time.StampedData;


/**
 *  Robot infrared data, include infrared distance and timestamp.
 *  Segway robot have two infrared device, respective correspondence {@link InfraredData#getLeftDistance()}
 *  and {@link InfraredData#getRightDistance()}.
 */
public class InfraredData implements StampedData, Parcelable {

    public static final Creator<InfraredData> CREATOR = new Creator<InfraredData>() {
        @Override
        public InfraredData createFromParcel(Parcel in) {
            return new InfraredData(in);
        }

        @Override
        public InfraredData[] newArray(int size) {
            return new InfraredData[size];
        }
    };
    long mTimestamp;
    float mLeftDistance;
    float mRightDistance;

    public InfraredData(long timestamp, float leftDistance, float rightDistance) {
        mTimestamp = timestamp;
        mLeftDistance = leftDistance;
        mRightDistance = rightDistance;
    }

    protected InfraredData(Parcel in) {
        mTimestamp = in.readLong();
        mLeftDistance = in.readFloat();
        mRightDistance = in.readFloat();
    }

    /**
     * Get the value of the robot left infrared distance obstacle, unit is mm。
     * @return left infrared distance
     */
    public float getLeftDistance() {
        return mLeftDistance;
    }

    /**
     * Get the value of the robot right infrared distance obstacle, unit is mm。
     * @return right infrared distance
     */
    public float getRightDistance() {
        return mRightDistance;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(mTimestamp);
        dest.writeFloat(mLeftDistance);
        dest.writeFloat(mRightDistance);
    }

    @Override
    public long getTimestamp() {
        return mTimestamp;
    }

    @Override
    public long diff(StampedData source) {
        return source.getTimestamp() - mTimestamp;
    }

    @Override
    public String toString() {
        return "InfraredData{" +
                "timestamp=" + mTimestamp +
                ", leftDistance=" + mLeftDistance +
                ", rightDistance=" + mRightDistance +
                '}';
    }
}
