/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.perception.sensor;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.algo.Pose2D;
import com.segway.robot.sdk.locomotion.head.Angle;
import com.segway.robot.sdk.locomotion.sbv.BasePose;
import com.segway.robot.sdk.locomotion.sbv.BaseTicks;
import com.segway.robot.sdk.locomotion.sbv.BaseWheelInfo;
import com.segway.robot.sdk.perception.sensor.InfraredData;
import com.segway.robot.sdk.perception.sensor.UltrasonicData;

public class RobotAllSensors
implements Parcelable {
    private final Angle mHeadWorldYaw;
    private final Angle mHeadWorldPitch;
    private final Angle mHeadWorldRoll;
    private final Angle mHeadJointYaw;
    private final Angle mHeadJointPitch;
    private final Angle mHeadJointRoll;
    private final BaseTicks mBaseTicks;
    private final UltrasonicData mUltrasonicData;
    private final InfraredData mInfraredData;
    private final BasePose mBasePose;
    private final Pose2D mPose2D;
    private final BaseWheelInfo mBaseWheelInfo;
    public static final Parcelable.Creator<RobotAllSensors> CREATOR = new Parcelable.Creator<RobotAllSensors>(){

        public RobotAllSensors createFromParcel(Parcel in) {
            return new RobotAllSensors(in);
        }

        public RobotAllSensors[] newArray(int size) {
            return new RobotAllSensors[size];
        }
    };

    public RobotAllSensors(Angle headWorldYaw, Angle headWorldPitch, Angle headWorldRoll, Angle headJointYaw, Angle headJointPitch, Angle headJointRoll, BaseTicks baseTicks, UltrasonicData ultrasonicData, InfraredData infraredData, BasePose basePose, Pose2D pose2D, BaseWheelInfo baseWheelInfo) {
        this.mHeadWorldYaw = headWorldYaw;
        this.mHeadWorldPitch = headWorldPitch;
        this.mHeadWorldRoll = headWorldRoll;
        this.mHeadJointYaw = headJointYaw;
        this.mHeadJointPitch = headJointPitch;
        this.mHeadJointRoll = headJointRoll;
        this.mBaseTicks = baseTicks;
        this.mUltrasonicData = ultrasonicData;
        this.mInfraredData = infraredData;
        this.mBasePose = basePose;
        this.mPose2D = pose2D;
        this.mBaseWheelInfo = baseWheelInfo;
    }

    protected RobotAllSensors(Parcel in) {
        this.mHeadWorldYaw = (Angle)in.readParcelable(Angle.class.getClassLoader());
        this.mHeadWorldPitch = (Angle)in.readParcelable(Angle.class.getClassLoader());
        this.mHeadWorldRoll = (Angle)in.readParcelable(Angle.class.getClassLoader());
        this.mHeadJointYaw = (Angle)in.readParcelable(Angle.class.getClassLoader());
        this.mHeadJointPitch = (Angle)in.readParcelable(Angle.class.getClassLoader());
        this.mHeadJointRoll = (Angle)in.readParcelable(Angle.class.getClassLoader());
        this.mBaseTicks = (BaseTicks)in.readParcelable(BaseTicks.class.getClassLoader());
        this.mUltrasonicData = (UltrasonicData)in.readParcelable(UltrasonicData.class.getClassLoader());
        this.mInfraredData = (InfraredData)in.readParcelable(InfraredData.class.getClassLoader());
        this.mBasePose = (BasePose)in.readParcelable(BasePose.class.getClassLoader());
        this.mPose2D = (Pose2D)in.readParcelable(Pose2D.class.getClassLoader());
        this.mBaseWheelInfo = (BaseWheelInfo)in.readParcelable(BaseWheelInfo.class.getClassLoader());
    }

    public Angle getHeadWorldYaw() {
        return this.mHeadWorldYaw;
    }

    public Angle getHeadWorldPitch() {
        return this.mHeadWorldPitch;
    }

    public Angle getHeadWorldRoll() {
        return this.mHeadWorldRoll;
    }

    public Angle getHeadJointYaw() {
        return this.mHeadJointYaw;
    }

    public Angle getHeadJointPitch() {
        return this.mHeadJointPitch;
    }

    public Angle getHeadJointRoll() {
        return this.mHeadJointRoll;
    }

    public BaseTicks getBaseTicks() {
        return this.mBaseTicks;
    }

    public UltrasonicData getUltrasonicData() {
        return this.mUltrasonicData;
    }

    public InfraredData getInfraredData() {
        return this.mInfraredData;
    }

    public BasePose getBasePose() {
        return this.mBasePose;
    }

    public Pose2D getPose2D() {
        return this.mPose2D;
    }

    public BaseWheelInfo getBaseWheelInfo() {
        return this.mBaseWheelInfo;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mHeadWorldYaw, flags);
        dest.writeParcelable((Parcelable)this.mHeadWorldPitch, flags);
        dest.writeParcelable((Parcelable)this.mHeadWorldRoll, flags);
        dest.writeParcelable((Parcelable)this.mHeadJointYaw, flags);
        dest.writeParcelable((Parcelable)this.mHeadJointPitch, flags);
        dest.writeParcelable((Parcelable)this.mHeadJointRoll, flags);
        dest.writeParcelable((Parcelable)this.mBaseTicks, flags);
        dest.writeParcelable((Parcelable)this.mUltrasonicData, flags);
        dest.writeParcelable((Parcelable)this.mInfraredData, flags);
        dest.writeParcelable((Parcelable)this.mBasePose, flags);
        dest.writeParcelable((Parcelable)this.mPose2D, flags);
        dest.writeParcelable((Parcelable)this.mBaseWheelInfo, flags);
    }

    public String toString() {
        return "RobotTotalInfo: HeadWorldYaw=" + this.mHeadWorldYaw.toString() + ", HeadWorldPitch=" + this.mHeadWorldPitch.toString() + ", HeadWorldRoll=" + this.mHeadWorldRoll.toString() + ", HeadJointYaw=" + this.mHeadJointYaw.toString() + ", HeadJointPitch=" + this.mHeadJointPitch.toString() + ", HeadJointRoll=" + this.mHeadJointRoll.toString() + ", BaseTicks=" + this.mBaseTicks.toString() + ", UltrasonicData=" + this.mUltrasonicData.toString() + ", InfraredData=" + this.mInfraredData.toString() + ", BasePose=" + this.mBasePose.toString() + ", Pose2D=" + this.mPose2D.toString() + ", BaseWheelInfo=" + this.mBaseWheelInfo.toString() + ", time diff=" + (System.currentTimeMillis() * 1000L - this.mHeadWorldYaw.getTimestamp());
    }
}

