package com.segway.robot.sdk.perception.sensor;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.algo.Pose2D;
import com.segway.robot.sdk.locomotion.head.Angle;
import com.segway.robot.sdk.locomotion.head.Head;
import com.segway.robot.sdk.locomotion.sbv.BasePose;
import com.segway.robot.sdk.locomotion.sbv.BaseTicks;
import com.segway.robot.sdk.locomotion.sbv.BaseWheelInfo;

/**
 * This class include robot all sensor value and some robot (head and base) position info.
 */
public class RobotTotalInfo implements Parcelable {
    private final Angle mHeadWorldYaw;
    private final Angle mHeadWorldPitch;
    private final Angle mHeadWorldRoll;
    private final Angle mHeadJointYaw;
    private final Angle mHeadJointPitch;
    private final Angle mHeadJointRoll;
    private final BaseTicks mBaseTicks;
    private final UltrasonicData mUltrasonicData;
    private final InfraredData mInfraredData;
    private final BasePose mBasePose;
    private final UwbEvent mUwbEvent;
    private final Pose2D mPose2D;
    private final BaseWheelInfo mBaseWheelInfo;

    public RobotTotalInfo(Angle headWorldYaw, Angle headWorldPitch, Angle headWorldRoll,
                          Angle headJointYaw, Angle headJointPitch, Angle headJointRoll,
                          BaseTicks baseTicks, UltrasonicData ultrasonicData,
                          InfraredData infraredData, BasePose basePose, UwbEvent uwbEvent,
                          Pose2D pose2D,
                          BaseWheelInfo wheelInfo) {
        mHeadWorldYaw = headWorldYaw;
        mHeadWorldPitch = headWorldPitch;
        mHeadWorldRoll = headWorldRoll;
        mHeadJointYaw = headJointYaw;
        mHeadJointPitch = headJointPitch;
        mHeadJointRoll = headJointRoll;
        mBaseTicks = baseTicks;
        mUltrasonicData = ultrasonicData;
        mInfraredData = infraredData;
        mBasePose = basePose;
        mUwbEvent = uwbEvent;
        mPose2D = pose2D;
        mBaseWheelInfo = wheelInfo;
    }

    protected RobotTotalInfo(Parcel in) {
        mHeadWorldYaw = in.readParcelable(Angle.class.getClassLoader());
        mHeadWorldPitch = in.readParcelable(Angle.class.getClassLoader());
        mHeadWorldRoll = in.readParcelable(Angle.class.getClassLoader());
        mHeadJointYaw = in.readParcelable(Angle.class.getClassLoader());
        mHeadJointPitch = in.readParcelable(Angle.class.getClassLoader());
        mHeadJointRoll = in.readParcelable(Angle.class.getClassLoader());
        mBaseTicks = in.readParcelable(BaseTicks.class.getClassLoader());
        mUltrasonicData = in.readParcelable(UltrasonicData.class.getClassLoader());
        mInfraredData = in.readParcelable(InfraredData.class.getClassLoader());
        mBasePose = in.readParcelable(BasePose.class.getClassLoader());
        mUwbEvent = in.readParcelable(UwbEvent.class.getClassLoader());
        mPose2D = in.readParcelable(Pose2D.class.getClassLoader());
        mBaseWheelInfo = in.readParcelable(BaseWheelInfo.class.getClassLoader());
    }

    public static final Creator<RobotTotalInfo> CREATOR = new Creator<RobotTotalInfo>() {
        @Override
        public RobotTotalInfo createFromParcel(Parcel in) {
            return new RobotTotalInfo(in);
        }

        @Override
        public RobotTotalInfo[] newArray(int size) {
            return new RobotTotalInfo[size];
        }
    };

    /**
     * see com.segway.robot.sdk.locomotion.head.Head#getWorldYaw()
     * @return angle
     */
    public Angle getHeadWorldYaw() {
        return mHeadWorldYaw;
    }

    /**
     * see com.segway.robot.sdk.locomotion.head.Head#getWorldPitch()
     * @return angle
     */
    public Angle getHeadWorldPitch() {
        return mHeadWorldPitch;
    }

    /**
     * see com.segway.robot.sdk.locomotion.head.Head#getWorldRoll()
     * @return angle
     */
    public Angle getHeadWorldRoll() {
        return mHeadWorldRoll;
    }

    /**
     * see com.segway.robot.sdk.locomotion.head.Head#getHeadJointYaw()
     * @return angle
     */
    public Angle getHeadJointYaw() {
        return mHeadJointYaw;
    }


    /**
     * see com.segway.robot.sdk.locomotion.head.Head#getHeadJointPitch()
     * @return angle
     */
    public Angle getHeadJointPitch() {
        return mHeadJointPitch;
    }

    /**
     * see com.segway.robot.sdk.locomotion.head.Head#getHeadJointRoll()
     * @return angle
     */
    public Angle getHeadJointRoll() {
        return mHeadJointRoll;
    }

    /**
     * Get the robot base ticks.
     * 90 ticks stand for 1 round of robot wheel.
     * see com.segway.robot.sdk.locomotion.sbv.BaseTicks
     * @return the current BaseTicks.
     */
    public BaseTicks getBaseTicks() {
        return mBaseTicks;
    }

    /**
     * @see com.segway.robot.sdk.perception.sensor.Sensor#getUltrasonicDistance()
     * @see UltrasonicData
     * @return {@link UltrasonicData}
     */
    public UltrasonicData getUltrasonicData() {
        return mUltrasonicData;
    }

    /**
     * @see com.segway.robot.sdk.perception.sensor.Sensor#getInfraredDistance()
     * @see com.segway.robot.sdk.perception.sensor.InfraredData
     * @return {@link InfraredData}
     */
    public InfraredData getInfraredData() {
        return mInfraredData;
    }

    /**
     * see com.segway.robot.sdk.locomotion.sbv.BasePose
     * @return base pose
     */
    public BasePose getBasePose() {
        return mBasePose;
    }

    public UwbEvent getUwbEvent() {
        return mUwbEvent;
    }

    /**
     * @see com.segway.robot.algo.Pose2D
     * @return pose2D
     */
    public Pose2D getPose2D() {
        return mPose2D;
    }

    /**
     * see com.segway.robot.sdk.locomotion.sbv.BaseWheelInfo
     * @return baseWheelInfo
     */
    public BaseWheelInfo getBaseWheelInfo(){ return mBaseWheelInfo; }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(mHeadWorldYaw, flags);
        dest.writeParcelable(mHeadWorldPitch, flags);
        dest.writeParcelable(mHeadWorldRoll, flags);
        dest.writeParcelable(mHeadJointYaw, flags);
        dest.writeParcelable(mHeadJointPitch, flags);
        dest.writeParcelable(mHeadJointRoll, flags);
        dest.writeParcelable(mBaseTicks, flags);
        dest.writeParcelable(mUltrasonicData, flags);
        dest.writeParcelable(mInfraredData, flags);
        dest.writeParcelable(mBasePose, flags);
        dest.writeParcelable(mUwbEvent, flags);
        dest.writeParcelable(mPose2D, flags);
        dest.writeParcelable(mBaseWheelInfo, flags);
    }

    @Override
    public String toString() {
        return "RobotTotalInfo:" +
                " HeadWorldYaw=" + mHeadWorldYaw +
                ", HeadWorldPitch=" + mHeadWorldPitch +
                ", HeadWorldRoll=" + mHeadWorldRoll +
                ", HeadJointYaw=" + mHeadJointYaw +
                ", HeadJointPitch=" + mHeadJointPitch +
                ", HeadJointRoll=" + mHeadJointRoll +
                ", BaseTicks=" + mBaseTicks +
                ", UltrasonicData=" + mUltrasonicData +
                ", InfraredData=" + mInfraredData +
                ", BasePose=" + mBasePose +
                ", UwbEvent=" + mUwbEvent +
                ", Pose2D=" + mPose2D +
                ", BaseWheelInfo=" + mBaseWheelInfo;
    }
}
