package com.segway.robot.mobile.sdk.connectivity;

import com.segway.robot.sdk.baseconnectivity.Message;

/**
 * StringMessage to be sent when {@link MobileMessageConnection} is created.
 */
public class StringMessage extends Message<String> {

    /**
     * Create an empty {@code StringMessage}.
     */
    public StringMessage() {
        super();
    }

    protected StringMessage(long timestamp, String content, int id) {
        super(timestamp, content, id);
    }

    /**
     * Create an empty {@code StringMessage} with the message content initialized.
     *
     * @param content the content of StringMessage to be sent.
     */
    public StringMessage(String content) {
        super(content);
    }

    /**
     * Get the message ID.
     *
     * @return the ID of StringMessage.
     */
    @Override
    public int getId() {
        return super.getId();
    }

    /**
     * Get the timestamp when the StringMessage is sent.
     *
     * @return the timestamp of StringMessage to be sent.
     */
    @Override
    public long getTimestampSent() {
        return super.getTimestampSent();
    }

    /**
     * Set the message content.
     *
     * @param message the content of the message to be set for StringMessage.
     */
    @Override
    public void setContent(String message) {
        super.setContent(message);
    }

    /**
     * Get the message content.
     *
     * @return the content of StringMessage.
     */
    @Override
    public String getContent() {
        return super.getContent();
    }
}
