/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.util;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlBuilderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(XmlBuilderFactory.class);
    private static final DocumentBuilderFactory FACTORY = XmlBuilderFactory.create();

    private XmlBuilderFactory() {
    }

    public static DocumentBuilderFactory getSecuredInstance() {
        return FACTORY;
    }

    private static DocumentBuilderFactory create() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", ClassLoader.getSystemClassLoader());
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        factory.setXIncludeAware(false);
        XmlBuilderFactory.trySetAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalDTD", "file:,jar:,jar:file:");
        XmlBuilderFactory.trySetAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalSchema", "file:,jar:,jar:file:");
        XmlBuilderFactory.trySetAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalStylesheet", "file:,jar:,jar:file:");
        XmlBuilderFactory.trySetFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        XmlBuilderFactory.trySetFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
        XmlBuilderFactory.trySetFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        XmlBuilderFactory.trySetFeature(factory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        XmlBuilderFactory.trySetFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        XmlBuilderFactory.trySetFeature(factory, "http://xml.org/sax/features/external-parameter-entitiess", false);
        XmlBuilderFactory.trySetFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        XmlBuilderFactory.trySetFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        return factory;
    }

    static void trySetFeature(DocumentBuilderFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (ParserConfigurationException e) {
            XmlBuilderFactory.logMessage(feature, "Could not set feature to factory: {}");
        }
    }

    static void trySetAttribute(DocumentBuilderFactory factory, String attribute, String value) {
        if ("all".equals(value) || value == null) {
            return;
        }
        try {
            factory.setAttribute(attribute, value);
        }
        catch (Exception e) {
            XmlBuilderFactory.logMessage(attribute, "Could not set attribute to document builder factory: {}");
        }
    }

    static void logMessage(String property, String s) {
        LOG.warn(s, (Object)property);
    }
}

