/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class PrimitiveUtil {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAP;
    private static final Map<Class<?>, Class<?>> WRAP_TO_PRIMITIVE;

    private PrimitiveUtil() {
    }

    private static void add(Map<Class<?>, Class<?>> forward, Map<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static <T> Class<T> wrap(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Class<?> wrapped = PRIMITIVE_TO_WRAP.get(type);
        return wrapped == null ? type : wrapped;
    }

    public static <T> Class<T> unwrap(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Class<?> unwrapped = WRAP_TO_PRIMITIVE.get(type);
        return unwrapped == null ? type : unwrapped;
    }

    static {
        HashMap primitiveMap = new HashMap();
        HashMap wrapToPrim = new HashMap();
        PrimitiveUtil.add(primitiveMap, wrapToPrim, Boolean.TYPE, Boolean.class);
        PrimitiveUtil.add(primitiveMap, wrapToPrim, Byte.TYPE, Byte.class);
        PrimitiveUtil.add(primitiveMap, wrapToPrim, Character.TYPE, Character.class);
        PrimitiveUtil.add(primitiveMap, wrapToPrim, Double.TYPE, Double.class);
        PrimitiveUtil.add(primitiveMap, wrapToPrim, Float.TYPE, Float.class);
        PrimitiveUtil.add(primitiveMap, wrapToPrim, Integer.TYPE, Integer.class);
        PrimitiveUtil.add(primitiveMap, wrapToPrim, Long.TYPE, Long.class);
        PrimitiveUtil.add(primitiveMap, wrapToPrim, Short.TYPE, Short.class);
        PrimitiveUtil.add(primitiveMap, wrapToPrim, Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAP = Collections.unmodifiableMap(primitiveMap);
        WRAP_TO_PRIMITIVE = Collections.unmodifiableMap(wrapToPrim);
    }
}

