/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.ccm;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.testinfra.ccm.DistributionCassandraVersions;
import com.datastax.oss.driver.api.testinfra.requirement.BackendType;
import com.datastax.oss.driver.shaded.guava.common.base.Joiner;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.driver.shaded.guava.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcmBridge
implements AutoCloseable {
    private static final Logger LOG;
    private static final AtomicInteger CLUSTER_ID;
    public static BackendType DISTRIBUTION;
    public static final String CCM_VERSION_PROPERTY;
    public static final Version VERSION;
    public static final String INSTALL_DIRECTORY;
    public static final String BRANCH;
    public static final Boolean DSE_ENABLEMENT;
    public static final Boolean SCYLLA_ENTERPRISE;
    public static final String CLUSTER_NAME = "ccm_1";
    public static final String DEFAULT_CLIENT_TRUSTSTORE_PASSWORD = "scylla1sfun";
    public static final String DEFAULT_CLIENT_TRUSTSTORE_PATH = "/client.truststore";
    public static final File DEFAULT_CLIENT_TRUSTSTORE_FILE;
    public static final String DEFAULT_CLIENT_KEYSTORE_PASSWORD = "scylla1sfun";
    public static final String DEFAULT_CLIENT_KEYSTORE_PATH = "/client.keystore";
    public static final File DEFAULT_CLIENT_KEYSTORE_FILE;
    public static final File DEFAULT_CLIENT_PRIVATE_KEY_FILE;
    public static final File DEFAULT_CLIENT_CERT_CHAIN_FILE;
    public static final String DEFAULT_SERVER_TRUSTSTORE_PASSWORD = "scylla1sfun";
    public static final String DEFAULT_SERVER_TRUSTSTORE_PATH = "/server.truststore";
    public static final String DEFAULT_SERVER_TRUSTSTORE_PEM_PATH = "/server.truststore.pem";
    private static final File DEFAULT_SERVER_TRUSTSTORE_FILE;
    private static final File DEFAULT_SERVER_TRUSTSTORE_PEM_FILE;
    public static final String DEFAULT_SERVER_KEYSTORE_PASSWORD = "scylla1sfun";
    public static final String DEFAULT_SERVER_KEYSTORE_PATH = "/server.keystore";
    public static final String DEFAULT_SERVER_PRIVATE_KEY_PATH = "/server.key";
    public static final String DEFAULT_SERVER_CERT_CHAIN_PATH = "/server.crt";
    private static final File DEFAULT_SERVER_KEYSTORE_FILE;
    private static final File DEFAULT_SERVER_PRIVATE_KEY_FILE;
    private static final File DEFAULT_SERVER_CERT_CHAIN_FILE;
    public static final String DEFAULT_SERVER_LOCALHOST_KEYSTORE_PATH = "/server_localhost.keystore";
    private static final File DEFAULT_SERVER_LOCALHOST_KEYSTORE_FILE;
    public static final Version V6_0_0;
    public static final Version V5_1_0;
    public static final Version V5_0_0;
    public static final Version V4_0_0;
    public static final Version V3_10;
    public static final Version V3_0_15;
    public static final Version V2_1_19;
    public static final Version V4_0_11;
    private static final Map<String, String> ENVIRONMENT_MAP;
    private final int[] nodes;
    private final Path configDirectory;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean created = new AtomicBoolean();
    private final String ipPrefix;
    private final Map<String, Object> cassandraConfiguration;
    private final Map<String, Object> dseConfiguration;
    private final List<String> rawDseYaml;
    private final List<String> createOptions;
    private final List<String> dseWorkloads;
    private final String jvmArgs;
    private static final String IN_MS_STR = "_in_ms";
    private static final int IN_MS_STR_LENGTH;
    private static final String ENABLE_STR = "enable_";
    private static final int ENABLE_STR_LENGTH;
    private static final String IN_KB_STR = "_in_kb";
    private static final int IN_KB_STR_LENGTH;

    private CcmBridge(Path configDirectory, int[] nodes, String ipPrefix, Map<String, Object> cassandraConfiguration, Map<String, Object> dseConfiguration, List<String> dseConfigurationRawYaml, List<String> createOptions, Collection<String> jvmArgs, List<String> dseWorkloads) {
        this.configDirectory = configDirectory;
        this.nodes = nodes.length == 1 ? new int[]{nodes[0], 0} : nodes;
        if (ipPrefix == null || ipPrefix.isEmpty()) {
            Integer clusterId = CLUSTER_ID.addAndGet(1);
            this.ipPrefix = String.format("127.%d.%d.", clusterId / 255, clusterId % 255 + 1);
        } else {
            this.ipPrefix = ipPrefix;
        }
        this.cassandraConfiguration = cassandraConfiguration;
        this.dseConfiguration = dseConfiguration;
        this.rawDseYaml = dseConfigurationRawYaml;
        this.createOptions = createOptions;
        if (CcmBridge.getCassandraVersion().nextStable().compareTo(Version.V4_1_0) >= 0 && !jvmArgs.contains("-Dcassandra.allow_new_old_config_keys=false") && !jvmArgs.contains("-Dcassandra.allow_new_old_config_keys=true")) {
            jvmArgs.add("-Dcassandra.allow_new_old_config_keys=true");
            jvmArgs.add("-Dcassandra.allow_duplicate_config_keys=false");
        }
        StringBuilder allJvmArgs = new StringBuilder("");
        String quote = CcmBridge.isWindows() ? "\"" : "";
        for (String jvmArg : jvmArgs) {
            allJvmArgs.append(" ");
            allJvmArgs.append(quote);
            allJvmArgs.append("--jvm_arg=");
            allJvmArgs.append(jvmArg);
            allJvmArgs.append(quote);
        }
        this.jvmArgs = allJvmArgs.toString();
        this.dseWorkloads = dseWorkloads;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", "").toLowerCase(Locale.US).contains("win");
    }

    private static Version parseCcmVersion() {
        String versionString = CCM_VERSION_PROPERTY;
        Version result = null;
        try {
            result = Version.parse((String)versionString);
            return result;
        }
        catch (IllegalArgumentException ex) {
            LOG.warn("Failed to parse ccm.version property '{}' as Version instance. Attempting to fetch it through 'ccm node versionfrombuild'", (Object)versionString);
            Path configDir = null;
            try {
                configDir = Files.createTempDirectory("ccmParseVer", new FileAttribute[0]);
                configDir.toFile().deleteOnExit();
                CcmBridge.execute(CommandLine.parse((String)String.format("ccm create get_version -n 1 %s --version %s --config-dir=%s", CcmBridge.isDistributionOf(BackendType.SCYLLA) ? "--scylla" : " ", versionString, configDir)));
                String output = CcmBridge.execute(CommandLine.parse((String)String.format("ccm node1 versionfrombuild --config-dir=%s", configDir)));
                result = Version.parse((String)output.trim());
                LOG.info("Cluster reports that {} corresponds to version {}", (Object)versionString, (Object)result);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (configDir != null) {
                        CcmBridge.execute(CommandLine.parse((String)("ccm remove get_version --config-dir=" + configDir)));
                    }
                }
                catch (Exception exception) {}
            }
            return result;
        }
    }

    public static Optional<Version> getScyllaVersion() {
        return CcmBridge.isDistributionOf(BackendType.SCYLLA) ? Optional.of(VERSION) : Optional.empty();
    }

    public Optional<String> getScyllaUnparsedVersion() {
        return CcmBridge.isDistributionOf(BackendType.SCYLLA) ? Optional.of(System.getProperty("ccm.version")) : Optional.empty();
    }

    public Optional<Version> getDseVersion() {
        return DSE_ENABLEMENT != false ? Optional.of(VERSION) : Optional.empty();
    }

    public static boolean isDistributionOf(BackendType type) {
        return DISTRIBUTION == type;
    }

    public static boolean isDistributionOf(BackendType type, VersionComparator comparator) {
        return CcmBridge.isDistributionOf(type) && comparator.accept(CcmBridge.getDistributionVersion(), CcmBridge.getCassandraVersion());
    }

    public static Version getDistributionVersion() {
        return VERSION;
    }

    public static Version getCassandraVersion() {
        if (CcmBridge.isDistributionOf(BackendType.CASSANDRA)) {
            return VERSION;
        }
        return DistributionCassandraVersions.getCassandraVersion(DISTRIBUTION, VERSION);
    }

    private String getCcmVersionString(String propertyString) {
        Version version = null;
        try {
            version = Version.parse((String)propertyString);
        }
        catch (IllegalArgumentException ex) {
            return propertyString;
        }
        if (CcmBridge.isDistributionOf(BackendType.SCYLLA)) {
            boolean shouldReplace;
            String versionString = version.toString();
            boolean bl = shouldReplace = SCYLLA_ENTERPRISE != false && version.compareTo(Version.parse((String)"2022.2.0-rc0")) < 0 || SCYLLA_ENTERPRISE == false && version.compareTo(Version.parse((String)"5.1.0-rc0")) < 0;
            if (shouldReplace) {
                versionString = versionString.replace(".0-", ".");
            }
            return "release:" + versionString;
        }
        if (version.getMajor() >= 4 && version.getMinor() == 0 && version.getPatch() == 0 && version.getPreReleaseLabels() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(version.getMajor()).append('.').append(version.getMinor());
            for (String preReleaseString : version.getPreReleaseLabels()) {
                sb.append('-').append(preReleaseString);
            }
            return sb.toString();
        }
        return version.toString();
    }

    public void create() {
        if (this.created.compareAndSet(false, true)) {
            if (INSTALL_DIRECTORY != null) {
                this.createOptions.add("--install-dir=" + new File(INSTALL_DIRECTORY).getAbsolutePath());
            } else if (BRANCH != null) {
                this.createOptions.add("-v git:" + BRANCH.trim().replaceAll("\"", ""));
            } else {
                this.createOptions.add("-v " + this.getCcmVersionString(CCM_VERSION_PROPERTY));
            }
            this.createOptions.addAll(Arrays.asList(DISTRIBUTION.getCcmOptions()));
            this.execute("create", CLUSTER_NAME, "-i", this.ipPrefix, "-n", Arrays.stream(this.nodes).mapToObj(n -> "" + n).collect(Collectors.joining(":")), this.createOptions.stream().collect(Collectors.joining(" ")));
            StringBuilder updateConfArguments = new StringBuilder();
            Version cassandraVersion = CcmBridge.getCassandraVersion();
            if (cassandraVersion.compareTo(Version.V2_2_0) >= 0 && !CcmBridge.isDistributionOf(BackendType.SCYLLA)) {
                this.cassandraConfiguration.put("enable_user_defined_functions", "true");
            }
            for (Map.Entry<String, Object> conf : this.cassandraConfiguration.entrySet()) {
                String originalKey = conf.getKey();
                Object originalValue = conf.getValue();
                String configKey = this.getConfigKey(originalKey, originalValue, cassandraVersion);
                String configValue = this.getConfigValue(originalKey, originalValue, cassandraVersion);
                updateConfArguments.append(configKey).append(':').append(configValue).append(' ');
            }
            if (updateConfArguments.length() > 0) {
                this.execute("updateconf", updateConfArguments.toString());
            }
            if (CcmBridge.isDistributionOf(BackendType.DSE)) {
                for (Map.Entry<String, Object> conf : this.dseConfiguration.entrySet()) {
                    this.execute("updatedseconf", String.format("%s:%s", conf.getKey(), conf.getValue()));
                }
                for (String yaml : this.rawDseYaml) {
                    this.executeUnsanitized("updatedseconf", "-y", yaml);
                }
                if (!this.dseWorkloads.isEmpty()) {
                    this.execute("setworkload", String.join((CharSequence)",", this.dseWorkloads));
                }
            }
        }
    }

    public void nodetool(int node, String ... args) {
        this.execute(String.format("node%d nodetool %s", node, Joiner.on((String)" ").join((Object[])args)));
    }

    public void dsetool(int node, String ... args) {
        this.execute(String.format("node%d dsetool %s", node, Joiner.on((String)" ").join((Object[])args)));
    }

    public void reloadCore(int node, String keyspace, String table, boolean reindex) {
        this.dsetool(node, "reload_core", keyspace + "." + table, "reindex=" + reindex);
    }

    public void start() {
        this.startWithArgs("--wait-for-binary-proto", "--wait-other-notice");
    }

    public void startWithArgs(String ... args) {
        if (this.started.compareAndSet(false, true)) {
            try {
                String[] arr = new String[args.length + 2];
                arr[0] = "start";
                arr[1] = this.jvmArgs;
                for (int i = 0; i < args.length; ++i) {
                    arr[i + 2] = args[i];
                }
                this.execute(arr);
            }
            catch (RuntimeException re) {
                this.executeCheckLogError();
                throw re;
            }
        }
    }

    public void startWithArgs(int n, String ... args) {
        String[] arr = new String[args.length + 2];
        arr[0] = "node" + n;
        arr[1] = "start";
        for (int i = 0; i < args.length; ++i) {
            arr[i + 2] = args[i];
        }
        this.execute(arr);
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            this.execute("stop");
        }
    }

    public void remove() {
        this.execute("remove");
    }

    public void pause(int n) {
        this.execute("node" + n, "pause");
    }

    public void resume(int n) {
        this.execute("node" + n, "resume");
    }

    public void start(int n) {
        if (CcmBridge.getCassandraVersion().compareTo(Version.V4_1_0) >= 0) {
            this.startWithArgs(n, "--jvm_arg=-Dcassandra.allow_new_old_config_keys=true", "--jvm_arg=-Dcassandra.allow_duplicate_config_keys=false", "--wait-for-binary-proto", "--wait-other-notice");
        } else {
            this.startWithArgs(n, "--wait-for-binary-proto", "--wait-other-notice");
        }
    }

    public void stop(int n) {
        this.execute("node" + n, "stop");
    }

    public void addWithoutStart(int n, String dc) {
        String[] initialArgs = new String[]{"add", "-i", this.ipPrefix + n, "-d", dc, "node" + n};
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(initialArgs));
        args.addAll(Arrays.asList(DISTRIBUTION.getCcmOptions()));
        this.execute(args.toArray(new String[0]));
    }

    public void add(int n, String dc) {
        this.addWithoutStart(n, dc);
        this.start(n);
    }

    public void decommission(int n) {
        this.nodetool(n, "decommission");
    }

    public void updateNodeConfig(int n, String key, Object value) {
        this.updateNodeConfig(n, (Map<String, Object>)ImmutableMap.builder().put((Object)key, value).build());
    }

    public void updateNodeConfig(int n, Map<String, Object> configs) {
        StringBuilder confStr = new StringBuilder();
        for (Map.Entry<String, Object> entry : configs.entrySet()) {
            confStr.append(entry.getKey()).append(":").append(entry.getValue()).append(" ");
        }
        this.execute(String.format("node%s updateconf %s", String.valueOf(n), confStr.toString()));
    }

    synchronized void execute(String ... args) {
        String command = "ccm " + String.join((CharSequence)" ", args) + " --config-dir=" + this.configDirectory.toFile().getAbsolutePath();
        CcmBridge.execute(CommandLine.parse((String)command));
    }

    synchronized void executeUnsanitized(String ... args) {
        String command = "ccm ";
        CommandLine cli = CommandLine.parse((String)command);
        for (String arg : args) {
            cli.addArgument(arg, false);
        }
        cli.addArgument("--config-dir=" + this.configDirectory.toFile().getAbsolutePath());
        CcmBridge.execute(cli);
    }

    private void executeCheckLogError() {
        String command = "ccm checklogerror --config-dir=" + this.configDirectory.toFile().getAbsolutePath();
        CcmBridge.execute(CommandLine.parse((String)command));
    }

    private static String execute(CommandLine cli) {
        final Logger logger = LOG;
        logger.info("Executing: " + cli);
        ExecuteWatchdog watchDog = new ExecuteWatchdog(TimeUnit.MINUTES.toMillis(10L));
        final StringWriter sw = new StringWriter();
        try (LogOutputStream outStream = new LogOutputStream(){

            protected void processLine(String line, int logLevel) {
                logger.info("ccmout> {}", (Object)line);
                sw.append(line).append(System.lineSeparator());
            }
        };
             LogOutputStream errStream = new LogOutputStream(){

            protected void processLine(String line, int logLevel) {
                logger.error("ccmerr> {}", (Object)line);
                sw.append(line).append(System.lineSeparator());
            }
        };){
            DefaultExecutor executor = new DefaultExecutor();
            PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outStream, (OutputStream)errStream);
            executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
            executor.setWatchdog(watchDog);
            int retValue = executor.execute(cli, ENVIRONMENT_MAP);
            if (retValue != 0) {
                logger.error("Non-zero exit code ({}) returned from executing ccm command: {}", (Object)retValue, (Object)cli);
            }
        }
        catch (IOException ex) {
            if (watchDog.killedProcess()) {
                throw new RuntimeException("The command '" + cli + "' was killed after 10 minutes");
            }
            throw new RuntimeException("The command '" + cli + "' failed to execute", ex);
        }
        return sw.toString();
    }

    @Override
    public void close() {
        if (this.created.compareAndSet(true, false)) {
            this.remove();
        }
    }

    private static File createTempStore(String storePath) {
        File f = null;
        try {
            f = File.createTempFile("server", ".store");
            try (FileOutputStream os = new FileOutputStream(f);){
                f.deleteOnExit();
                Resources.copy((URL)CcmBridge.class.getResource(storePath), (OutputStream)os);
            }
        }
        catch (IOException e) {
            LOG.warn("Failure to write keystore, SSL-enabled servers may fail to start.", (Throwable)e);
        }
        return f;
    }

    public String getNodeIpAddress(int nodeId) {
        return this.ipPrefix + nodeId;
    }

    private String getConfigKey(String originalKey, Object originalValue, Version cassandraVersion) {
        if (originalKey.contains(".")) {
            return originalKey;
        }
        if (cassandraVersion.compareTo(Version.V4_1_0) < 0) {
            return originalKey;
        }
        if (originalKey.endsWith(IN_MS_STR)) {
            return originalKey.substring(0, originalKey.length() - IN_MS_STR_LENGTH);
        }
        if (originalKey.startsWith(ENABLE_STR)) {
            return originalKey.substring(ENABLE_STR_LENGTH) + "_enabled";
        }
        if (originalKey.endsWith(IN_KB_STR)) {
            return originalKey.substring(0, originalKey.length() - IN_KB_STR_LENGTH);
        }
        return originalKey;
    }

    private String getConfigValue(String originalKey, Object originalValue, Version cassandraVersion) {
        String originalValueStr = originalValue.toString();
        if (cassandraVersion.compareTo(Version.V4_1_0) < 0) {
            return originalValueStr;
        }
        if (originalKey.endsWith(IN_MS_STR)) {
            return originalValueStr + "ms";
        }
        if (originalKey.endsWith(IN_KB_STR)) {
            return originalValueStr + "KiB";
        }
        return originalValueStr;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        String ccmJavaHome;
        LOG = LoggerFactory.getLogger(CcmBridge.class);
        CLUSTER_ID = new AtomicInteger();
        DISTRIBUTION = BackendType.valueOf(System.getProperty("ccm.distribution", BackendType.CASSANDRA.name()).toUpperCase());
        CCM_VERSION_PROPERTY = System.getProperty("ccm.version", "4.0.0");
        VERSION = Objects.requireNonNull(CcmBridge.parseCcmVersion());
        INSTALL_DIRECTORY = System.getProperty("ccm.directory");
        BRANCH = System.getProperty("ccm.branch");
        DSE_ENABLEMENT = Boolean.getBoolean("ccm.dse");
        SCYLLA_ENTERPRISE = String.valueOf(VERSION.getMajor()).matches("\\d{4}");
        DEFAULT_CLIENT_TRUSTSTORE_FILE = CcmBridge.createTempStore(DEFAULT_CLIENT_TRUSTSTORE_PATH);
        DEFAULT_CLIENT_KEYSTORE_FILE = CcmBridge.createTempStore(DEFAULT_CLIENT_KEYSTORE_PATH);
        DEFAULT_CLIENT_PRIVATE_KEY_FILE = CcmBridge.createTempStore("/client.key");
        DEFAULT_CLIENT_CERT_CHAIN_FILE = CcmBridge.createTempStore("/client.crt");
        DEFAULT_SERVER_TRUSTSTORE_FILE = CcmBridge.createTempStore(DEFAULT_SERVER_TRUSTSTORE_PATH);
        DEFAULT_SERVER_TRUSTSTORE_PEM_FILE = CcmBridge.createTempStore(DEFAULT_SERVER_TRUSTSTORE_PEM_PATH);
        DEFAULT_SERVER_KEYSTORE_FILE = CcmBridge.createTempStore(DEFAULT_SERVER_KEYSTORE_PATH);
        DEFAULT_SERVER_PRIVATE_KEY_FILE = CcmBridge.createTempStore(DEFAULT_SERVER_PRIVATE_KEY_PATH);
        DEFAULT_SERVER_CERT_CHAIN_FILE = CcmBridge.createTempStore(DEFAULT_SERVER_CERT_CHAIN_PATH);
        DEFAULT_SERVER_LOCALHOST_KEYSTORE_FILE = null;
        V6_0_0 = Version.parse((String)"6.0.0");
        V5_1_0 = Version.parse((String)"5.1.0");
        V5_0_0 = Version.parse((String)"5.0.0");
        V4_0_0 = Version.parse((String)"4.0.0");
        V3_10 = Version.parse((String)"3.10");
        V3_0_15 = Version.parse((String)"3.0.15");
        V2_1_19 = Version.parse((String)"2.1.19");
        V4_0_11 = Version.parse((String)"4.0.11");
        HashMap envMap = Maps.newHashMap(new ProcessBuilder(new String[0]).environment());
        if (CcmBridge.isDistributionOf(BackendType.SCYLLA) && SCYLLA_ENTERPRISE.booleanValue()) {
            envMap.put("SCYLLA_PRODUCT", "enterprise");
        }
        LOG.info("CCM Bridge configured with {} version {}", (Object)DISTRIBUTION.getFriendlyName(), (Object)VERSION);
        String ccmPath = System.getProperty("ccm.path");
        if (ccmPath != null) {
            String existingPath = (String)envMap.get("PATH");
            if (existingPath == null) {
                existingPath = "";
            }
            envMap.put("PATH", ccmPath + File.pathSeparator + existingPath);
        }
        if ((ccmJavaHome = System.getProperty("ccm.java.home")) != null) {
            envMap.put("JAVA_HOME", ccmJavaHome);
        }
        ENVIRONMENT_MAP = ImmutableMap.copyOf((Map)envMap);
        IN_MS_STR_LENGTH = IN_MS_STR.length();
        ENABLE_STR_LENGTH = ENABLE_STR.length();
        IN_KB_STR_LENGTH = IN_KB_STR.length();
    }

    public static interface VersionComparator {
        public boolean accept(Version var1, Version var2);
    }

    public static class Builder {
        private int[] nodes = new int[]{1};
        private final Map<String, Object> cassandraConfiguration = new LinkedHashMap<String, Object>();
        private final Map<String, Object> dseConfiguration = new LinkedHashMap<String, Object>();
        private final List<String> dseRawYaml = new ArrayList<String>();
        private final List<String> jvmArgs = new ArrayList<String>();
        private String ipPrefix;
        private final List<String> createOptions = new ArrayList<String>();
        private final List<String> dseWorkloads = new ArrayList<String>();
        private final Path configDirectory;

        private Builder() {
            try {
                this.configDirectory = Files.createTempDirectory("ccm", new FileAttribute[0]);
                this.configDirectory.toFile().deleteOnExit();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.withCassandraConfiguration("auto_snapshot", "false");
        }

        public Builder withCassandraConfiguration(String key, Object value) {
            this.cassandraConfiguration.put(key, value);
            return this;
        }

        public Builder withDseConfiguration(String key, Object value) {
            this.dseConfiguration.put(key, value);
            return this;
        }

        public Builder withDseConfiguration(String rawYaml) {
            this.dseRawYaml.add(rawYaml);
            return this;
        }

        public Builder withJvmArgs(String ... jvmArgs) {
            Collections.addAll(this.jvmArgs, jvmArgs);
            return this;
        }

        public Builder withNodes(int ... nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder withIpPrefix(String ipPrefix) {
            this.ipPrefix = ipPrefix;
            return this;
        }

        public Builder withCreateOption(String option) {
            this.createOptions.add(option);
            return this;
        }

        public Builder withSsl() {
            this.cassandraConfiguration.put("client_encryption_options.enabled", "true");
            if (CcmBridge.isDistributionOf(BackendType.SCYLLA)) {
                this.cassandraConfiguration.put("client_encryption_options.certificate", DEFAULT_SERVER_CERT_CHAIN_FILE.getAbsolutePath());
                this.cassandraConfiguration.put("client_encryption_options.keyfile", DEFAULT_SERVER_PRIVATE_KEY_FILE.getAbsolutePath());
            } else {
                this.cassandraConfiguration.put("client_encryption_options.optional", "false");
                this.cassandraConfiguration.put("client_encryption_options.keystore", DEFAULT_SERVER_KEYSTORE_FILE.getAbsolutePath());
                this.cassandraConfiguration.put("client_encryption_options.keystore_password", "scylla1sfun");
            }
            return this;
        }

        public Builder withSslLocalhostCn() {
            this.cassandraConfiguration.put("client_encryption_options.enabled", "true");
            this.cassandraConfiguration.put("client_encryption_options.optional", "false");
            this.cassandraConfiguration.put("client_encryption_options.keystore", DEFAULT_SERVER_LOCALHOST_KEYSTORE_FILE.getAbsolutePath());
            this.cassandraConfiguration.put("client_encryption_options.keystore_password", "scylla1sfun");
            return this;
        }

        public Builder withSslAuth() {
            this.withSsl();
            this.cassandraConfiguration.put("client_encryption_options.require_client_auth", "true");
            if (CcmBridge.isDistributionOf(BackendType.SCYLLA)) {
                this.cassandraConfiguration.put("client_encryption_options.truststore", DEFAULT_SERVER_TRUSTSTORE_PEM_FILE.getAbsolutePath());
            } else {
                this.cassandraConfiguration.put("client_encryption_options.truststore", DEFAULT_SERVER_TRUSTSTORE_FILE.getAbsolutePath());
                this.cassandraConfiguration.put("client_encryption_options.truststore_password", "scylla1sfun");
            }
            return this;
        }

        public Builder withDseWorkloads(String ... workloads) {
            this.dseWorkloads.addAll(Arrays.asList(workloads));
            return this;
        }

        public CcmBridge build() {
            return new CcmBridge(this.configDirectory, this.nodes, this.ipPrefix, this.cassandraConfiguration, this.dseConfiguration, this.dseRawYaml, this.createOptions, this.jvmArgs, this.dseWorkloads);
        }
    }
}

