/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.metrics.micrometer;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.MetricId;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.metrics.micrometer.MicrometerMetricUpdater;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MicrometerSessionMetricUpdater
extends MicrometerMetricUpdater<SessionMetric>
implements SessionMetricUpdater {
    public MicrometerSessionMetricUpdater(InternalDriverContext context, Set<SessionMetric> enabledMetrics, MeterRegistry registry) {
        super(context, enabledMetrics, registry);
        DriverExecutionProfile profile = context.getConfig().getDefaultProfile();
        this.initializeGauge(DefaultSessionMetric.CONNECTED_NODES, profile, () -> ((MicrometerSessionMetricUpdater)this).connectedNodes());
        this.initializeGauge(DefaultSessionMetric.THROTTLING_QUEUE_SIZE, profile, () -> ((MicrometerSessionMetricUpdater)this).throttlingQueueSize());
        this.initializeGauge(DefaultSessionMetric.CQL_PREPARED_CACHE_SIZE, profile, () -> ((MicrometerSessionMetricUpdater)this).preparedStatementCacheSize());
        this.initializeCounter(DefaultSessionMetric.CQL_CLIENT_TIMEOUTS, profile);
        this.initializeCounter(DefaultSessionMetric.THROTTLING_ERRORS, profile);
        this.initializeCounter(DseSessionMetric.GRAPH_CLIENT_TIMEOUTS, profile);
        this.initializeTimer(DefaultSessionMetric.CQL_REQUESTS, profile);
        this.initializeTimer(DefaultSessionMetric.THROTTLING_DELAY, profile);
        this.initializeTimer(DseSessionMetric.CONTINUOUS_CQL_REQUESTS, profile);
        this.initializeTimer(DseSessionMetric.GRAPH_REQUESTS, profile);
    }

    @Override
    protected MetricId getMetricId(SessionMetric metric) {
        return this.context.getMetricIdGenerator().sessionMetricId(metric);
    }

    @Override
    protected Timer.Builder configureTimer(Timer.Builder builder, SessionMetric metric, MetricId id) {
        DriverExecutionProfile profile = this.context.getConfig().getDefaultProfile();
        super.configureTimer(builder, metric, id);
        if (metric == DefaultSessionMetric.CQL_REQUESTS) {
            builder.minimumExpectedValue(profile.getDuration((DriverOption)DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_LOWEST)).maximumExpectedValue(profile.getDuration((DriverOption)DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_HIGHEST)).serviceLevelObjectives(profile.isDefined((DriverOption)DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_SLO) ? profile.getDurationList((DriverOption)DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_SLO).toArray(new Duration[0]) : null).percentilePrecision(profile.isDefined((DriverOption)DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_DIGITS) ? Integer.valueOf(profile.getInt((DriverOption)DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_DIGITS)) : null);
            MicrometerSessionMetricUpdater.configurePercentilesPublishIfDefined(builder, profile, (DriverOption)DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_PUBLISH_PERCENTILES);
        } else if (metric == DefaultSessionMetric.THROTTLING_DELAY) {
            builder.minimumExpectedValue(profile.getDuration((DriverOption)DefaultDriverOption.METRICS_SESSION_THROTTLING_LOWEST)).maximumExpectedValue(profile.getDuration((DriverOption)DefaultDriverOption.METRICS_SESSION_THROTTLING_HIGHEST)).serviceLevelObjectives(profile.isDefined((DriverOption)DefaultDriverOption.METRICS_SESSION_THROTTLING_SLO) ? profile.getDurationList((DriverOption)DefaultDriverOption.METRICS_SESSION_THROTTLING_SLO).toArray(new Duration[0]) : null).percentilePrecision(profile.isDefined((DriverOption)DefaultDriverOption.METRICS_SESSION_THROTTLING_DIGITS) ? Integer.valueOf(profile.getInt((DriverOption)DefaultDriverOption.METRICS_SESSION_THROTTLING_DIGITS)) : null);
            MicrometerSessionMetricUpdater.configurePercentilesPublishIfDefined(builder, profile, (DriverOption)DefaultDriverOption.METRICS_SESSION_THROTTLING_PUBLISH_PERCENTILES);
        } else if (metric == DseSessionMetric.CONTINUOUS_CQL_REQUESTS) {
            builder.minimumExpectedValue(profile.getDuration((DriverOption)DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_LOWEST)).maximumExpectedValue(profile.getDuration((DriverOption)DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_HIGHEST)).serviceLevelObjectives(profile.isDefined((DriverOption)DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_SLO) ? profile.getDurationList((DriverOption)DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_SLO).toArray(new Duration[0]) : null).percentilePrecision(profile.isDefined((DriverOption)DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_DIGITS) ? Integer.valueOf(profile.getInt((DriverOption)DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_DIGITS)) : null);
            MicrometerSessionMetricUpdater.configurePercentilesPublishIfDefined(builder, profile, (DriverOption)DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_PUBLISH_PERCENTILES);
        } else if (metric == DseSessionMetric.GRAPH_REQUESTS) {
            builder.minimumExpectedValue(profile.getDuration((DriverOption)DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_LOWEST)).maximumExpectedValue(profile.getDuration((DriverOption)DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_HIGHEST)).serviceLevelObjectives(profile.isDefined((DriverOption)DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_SLO) ? profile.getDurationList((DriverOption)DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_SLO).toArray(new Duration[0]) : null).percentilePrecision(profile.isDefined((DriverOption)DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_DIGITS) ? Integer.valueOf(profile.getInt((DriverOption)DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_DIGITS)) : null);
            MicrometerSessionMetricUpdater.configurePercentilesPublishIfDefined(builder, profile, (DriverOption)DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_PUBLISH_PERCENTILES);
        }
        return builder;
    }
}

