/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;

public class LoggingGenerator {
    private static final ClassName LOGGER_FACTORY_CLASS_NAME = ClassName.get((String)"org.slf4j", (String)"LoggerFactory", (String[])new String[0]);
    private static final ClassName LOGGER_CLASS_NAME = ClassName.get((String)"org.slf4j", (String)"Logger", (String[])new String[0]);
    private final boolean logsEnabled;

    public LoggingGenerator(boolean logsEnabled) {
        this.logsEnabled = logsEnabled;
    }

    public void addLoggerField(TypeSpec.Builder classBuilder, ClassName className) {
        if (this.logsEnabled) {
            classBuilder.addField(FieldSpec.builder((TypeName)LOGGER_CLASS_NAME, (String)"LOG", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$T.getLogger($T.class)", new Object[]{LOGGER_FACTORY_CLASS_NAME, className}).build());
        }
    }

    public void debug(MethodSpec.Builder builder, String template, CodeBlock ... arguments) {
        this.log("debug", builder, template, arguments);
    }

    public void warn(MethodSpec.Builder builder, String template, CodeBlock ... arguments) {
        this.log("warn", builder, template, arguments);
    }

    public void log(String logLevel, MethodSpec.Builder builder, String template, CodeBlock ... arguments) {
        if (this.logsEnabled) {
            builder.addCode("$[LOG.$L($S", new Object[]{logLevel, template});
            for (CodeBlock argument : arguments) {
                builder.addCode(",\n$L", new Object[]{argument});
            }
            builder.addCode(");$]\n", new Object[0]);
        }
    }
}

