/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Objects;

public class Strings {
    private static final ImmutableSet<String> RESERVED_KEYWORDS = ImmutableSet.of((Object)"-infinity", (Object)"-nan", (Object)"add", (Object)"allow", (Object)"alter", (Object)"and", (Object[])new String[]{"any", "apply", "asc", "authorize", "batch", "begin", "by", "cast", "columnfamily", "create", "default", "delete", "desc", "describe", "drop", "each_quorum", "entries", "execute", "from", "full", "grant", "if", "in", "index", "inet", "infinity", "insert", "into", "is", "keyspace", "keyspaces", "limit", "local_one", "local_quorum", "materialized", "mbean", "mbeans", "modify", "nan", "norecursive", "not", "null", "of", "on", "one", "or", "order", "password", "primary", "quorum", "rename", "replace", "revoke", "schema", "scylla_clustering_bound", "scylla_counter_shard_list", "scylla_timeuuid_list_index", "select", "set", "table", "to", "token", "three", "truncate", "two", "unlogged", "unset", "update", "use", "using", "view", "where", "with"});

    public static boolean isQuoted(String value) {
        return Strings.isQuoted(value, '\'');
    }

    public static String quote(String value) {
        return Strings.quote(value, '\'');
    }

    public static String unquote(String value) {
        return Strings.unquote(value, '\'');
    }

    public static boolean isDoubleQuoted(String value) {
        return Strings.isQuoted(value, '\"');
    }

    public static String doubleQuote(String value) {
        return Strings.quote(value, '\"');
    }

    public static String unDoubleQuote(String value) {
        return Strings.unquote(value, '\"');
    }

    public static boolean needsDoubleQuotes(String s) {
        assert (s != null && !s.isEmpty());
        char c = s.charAt(0);
        if (c < 'a' || c > 'z') {
            return true;
        }
        for (int i = 1; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9' || c == '_' || c >= 'a' && c <= 'z') continue;
            return true;
        }
        return Strings.isReservedCqlKeyword(s);
    }

    private static boolean isQuoted(String value, char quoteChar) {
        return value != null && value.length() > 1 && value.charAt(0) == quoteChar && value.charAt(value.length() - 1) == quoteChar;
    }

    private static String emptyQuoted(char quoteChar) {
        assert (quoteChar == '\"' || quoteChar == '\'');
        if (quoteChar == '\"') {
            return "\"\"";
        }
        return "''";
    }

    private static String quote(String text, char quoteChar) {
        if (text == null || text.isEmpty()) {
            return Strings.emptyQuoted(quoteChar);
        }
        int nbMatch = 0;
        int start = -1;
        do {
            if ((start = text.indexOf(quoteChar, start + 1)) == -1) continue;
            ++nbMatch;
        } while (start != -1);
        if (nbMatch == 0) {
            return quoteChar + text + quoteChar;
        }
        int newLength = 2 + text.length() + nbMatch;
        char[] result = new char[newLength];
        result[0] = quoteChar;
        result[newLength - 1] = quoteChar;
        int newIdx = 1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == quoteChar) {
                result[newIdx++] = c;
                result[newIdx++] = c;
                continue;
            }
            result[newIdx++] = c;
        }
        return new String(result);
    }

    private static String unquote(String text, char quoteChar) {
        if (!Strings.isQuoted(text, quoteChar)) {
            return text;
        }
        if (text.length() == 2) {
            return "";
        }
        String search = Strings.emptyQuoted(quoteChar);
        int nbMatch = 0;
        int start = -1;
        do {
            if ((start = text.indexOf(search, start + 2)) == -1 || start == text.length() - 2) continue;
            ++nbMatch;
        } while (start != -1);
        if (nbMatch == 0) {
            return text.substring(1, text.length() - 1);
        }
        int newLength = text.length() - nbMatch - 2;
        char[] result = new char[newLength];
        int newIdx = 0;
        boolean firstFound = false;
        for (int i = 1; i < text.length() - 1; ++i) {
            char c = text.charAt(i);
            if (c == quoteChar) {
                if (firstFound) {
                    firstFound = false;
                    continue;
                }
                firstFound = true;
                result[newIdx++] = c;
                continue;
            }
            result[newIdx++] = c;
            firstFound = false;
        }
        return new String(result);
    }

    @VisibleForTesting
    static boolean isReservedCqlKeyword(String id) {
        return id != null && RESERVED_KEYWORDS.contains((Object)id.toLowerCase(Locale.ROOT));
    }

    public static boolean isLongLiteral(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if ((c >= '0' || i == 0 && c == '-') && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static String requireNotEmpty(String text, String name) {
        Objects.requireNonNull(text, name + " cannot be null");
        if (text.isEmpty()) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
        return text;
    }

    private Strings() {
    }
}

