/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.metadata.NodeShardingInfo;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.internal.core.metadata.token.TokenLong64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class ShardingInfo
implements NodeShardingInfo {
    private static final String SCYLLA_SHARD_PARAM_KEY = "SCYLLA_SHARD";
    private static final String SCYLLA_NR_SHARDS_PARAM_KEY = "SCYLLA_NR_SHARDS";
    private static final String SCYLLA_PARTITIONER = "SCYLLA_PARTITIONER";
    private static final String SCYLLA_SHARDING_ALGORITHM = "SCYLLA_SHARDING_ALGORITHM";
    private static final String SCYLLA_SHARDING_IGNORE_MSB = "SCYLLA_SHARDING_IGNORE_MSB";
    private static final String SCYLLA_SHARD_AWARE_PORT_PARAM_KEY = "SCYLLA_SHARD_AWARE_PORT";
    private static final String SCYLLA_SHARD_AWARE_PORT_SSL_PARAM_KEY = "SCYLLA_SHARD_AWARE_PORT_SSL";
    private final int shardsCount;
    private final String partitioner;
    private final String shardingAlgorithm;
    private final int shardingIgnoreMSB;
    private final Integer shardAwarePort;
    private final Integer shardAwarePortSsl;

    private ShardingInfo(int shardsCount, String partitioner, String shardingAlgorithm, int shardingIgnoreMSB, Integer shardAwarePort, Integer shardAwarePortSsl) {
        this.shardsCount = shardsCount;
        this.partitioner = partitioner;
        this.shardingAlgorithm = shardingAlgorithm;
        this.shardingIgnoreMSB = shardingIgnoreMSB;
        this.shardAwarePort = shardAwarePort;
        this.shardAwarePortSsl = shardAwarePortSsl;
    }

    @Override
    public int getShardsCount() {
        return this.shardsCount;
    }

    public String getPartitioner() {
        return this.partitioner;
    }

    public String getShardingAlgorithm() {
        return this.shardingAlgorithm;
    }

    @Override
    public int shardId(Token t) {
        if (!(t instanceof TokenLong64)) {
            return ThreadLocalRandom.current().nextInt(this.shardsCount);
        }
        long token = ((TokenLong64)t).getValue();
        token += Long.MIN_VALUE;
        long tokLo = (token <<= this.shardingIgnoreMSB) & 0xFFFFFFFFL;
        long tokHi = token >>> 32 & 0xFFFFFFFFL;
        long mul1 = tokLo * (long)this.shardsCount;
        long mul2 = tokHi * (long)this.shardsCount;
        long sum = (mul1 >>> 32) + mul2;
        return (int)(sum >>> 32);
    }

    @Override
    public Integer getShardAwarePort() {
        return this.shardAwarePort;
    }

    @Override
    public Integer getShardAwarePortSsl() {
        return this.shardAwarePortSsl;
    }

    public static ConnectionShardingInfo parseShardingInfo(Map<String, List<String>> params) {
        Integer shardId = ShardingInfo.parseInt(params, SCYLLA_SHARD_PARAM_KEY);
        Integer shardsCount = ShardingInfo.parseInt(params, SCYLLA_NR_SHARDS_PARAM_KEY);
        String partitioner = ShardingInfo.parseString(params, SCYLLA_PARTITIONER);
        String shardingAlgorithm = ShardingInfo.parseString(params, SCYLLA_SHARDING_ALGORITHM);
        Integer shardingIgnoreMSB = ShardingInfo.parseInt(params, SCYLLA_SHARDING_IGNORE_MSB);
        Integer shardAwarePort = ShardingInfo.parseInt(params, SCYLLA_SHARD_AWARE_PORT_PARAM_KEY);
        Integer shardAwarePortSsl = ShardingInfo.parseInt(params, SCYLLA_SHARD_AWARE_PORT_SSL_PARAM_KEY);
        if (shardId == null || shardsCount == null || partitioner == null || shardingAlgorithm == null || shardingIgnoreMSB == null || !partitioner.equals("org.apache.cassandra.dht.Murmur3Partitioner") || !shardingAlgorithm.equals("biased-token-round-robin")) {
            return null;
        }
        return new ConnectionShardingInfo(shardId, new ShardingInfo(shardsCount, partitioner, shardingAlgorithm, shardingIgnoreMSB, shardAwarePort, shardAwarePortSsl));
    }

    private static String parseString(Map<String, List<String>> params, String key) {
        List<String> val = params.get(key);
        if (val == null || val.size() != 1) {
            return null;
        }
        return val.get(0);
    }

    private static Integer parseInt(Map<String, List<String>> params, String key) {
        String val = ShardingInfo.parseString(params, key);
        if (val == null) {
            return null;
        }
        try {
            return Integer.valueOf(val);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class ConnectionShardingInfo {
        public final int shardId;
        public final ShardingInfo shardingInfo;

        private ConnectionShardingInfo(int shardId, ShardingInfo shardingInfo) {
            this.shardId = shardId;
            this.shardingInfo = shardingInfo;
        }
    }
}

