/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.esri.core.geometry;

final class StridedIndexTypeCollection {
    private int[][] m_buffer = null;
    private int m_firstFree = -1;
    private int m_last = 0;
    private int m_size = 0;
    private int m_capacity = 0;
    private int m_bufferSize = 0;
    private int m_stride;
    private int m_realStride;
    private int m_blockSize;
    private static final int m_realBlockSize = 16384;
    private static final int m_blockMask = 16383;
    private static final int m_blockPower = 14;
    private static final int[] st_sizes = new int[]{16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};

    StridedIndexTypeCollection(int stride) {
        this.m_stride = stride;
        this.m_realStride = stride;
        this.m_blockSize = 16384 / this.m_realStride;
    }

    private boolean dbgdelete_(int element) {
        this.m_buffer[element >> 14][(element & 0x3FFF) + 1] = -2125315821;
        return true;
    }

    void deleteElement(int element) {
        assert (this.dbgdelete_(element));
        int totalStrides = (element >> 14) * this.m_blockSize * this.m_realStride + (element & 0x3FFF);
        if (totalStrides < this.m_last * this.m_realStride) {
            this.m_buffer[element >> 14][element & 0x3FFF] = this.m_firstFree;
            this.m_firstFree = element;
        } else {
            assert (totalStrides == this.m_last * this.m_realStride);
            --this.m_last;
        }
        --this.m_size;
    }

    int getField(int element, int field) {
        assert (this.m_buffer[element >> 14][(element & 0x3FFF) + 1] != -2125315821);
        return this.m_buffer[element >> 14][(element & 0x3FFF) + field];
    }

    void setField(int element, int field, int value) {
        assert (this.m_buffer[element >> 14][(element & 0x3FFF) + 1] != -2125315821);
        this.m_buffer[element >> 14][(element & 0x3FFF) + field] = value;
    }

    int getStride() {
        return this.m_stride;
    }

    int newElement() {
        int element = this.m_firstFree;
        if (element == -1) {
            if (this.m_last == this.m_capacity) {
                long newcap;
                long l = newcap = this.m_capacity != 0 ? ((long)this.m_capacity + 1L) * 3L / 2L : 1L;
                if (newcap > Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                }
                if (newcap == (long)this.m_capacity) {
                    throw new IndexOutOfBoundsException();
                }
                this.grow_(newcap);
            }
            element = (this.m_last / this.m_blockSize << 14) + this.m_last % this.m_blockSize * this.m_realStride;
            ++this.m_last;
        } else {
            this.m_firstFree = this.m_buffer[element >> 14][element & 0x3FFF];
        }
        ++this.m_size;
        int[] ar = this.m_buffer[element >> 14];
        int ind = element & 0x3FFF;
        for (int i = 0; i < this.m_stride; ++i) {
            ar[ind + i] = -1;
        }
        return element;
    }

    int elementToIndex(int element) {
        return (element >> 14) * this.m_blockSize + (element & 0x3FFF) / this.m_realStride;
    }

    void deleteAll(boolean b_free_memory) {
        this.m_firstFree = -1;
        this.m_last = 0;
        this.m_size = 0;
        if (b_free_memory) {
            this.m_buffer = null;
            this.m_capacity = 0;
        }
    }

    int size() {
        return this.m_size;
    }

    void setCapacity(int capacity) {
        if (capacity > this.m_capacity) {
            this.grow_(capacity);
        }
    }

    int capacity() {
        return this.m_capacity;
    }

    void swap(int element1, int element2) {
        int[] ar1 = this.m_buffer[element1 >> 14];
        int[] ar2 = this.m_buffer[element2 >> 14];
        int ind1 = element1 & 0x3FFF;
        int ind2 = element2 & 0x3FFF;
        for (int i = 0; i < this.m_stride; ++i) {
            int tmp = ar1[ind1 + i];
            ar1[ind1 + i] = ar2[ind2 + i];
            ar2[ind2 + i] = tmp;
        }
    }

    void swapField(int element1, int element2, int field) {
        int[] ar1 = this.m_buffer[element1 >> 14];
        int[] ar2 = this.m_buffer[element2 >> 14];
        int ind1 = (element1 & 0x3FFF) + field;
        int ind2 = (element2 & 0x3FFF) + field;
        int tmp = ar1[ind1];
        ar1[ind1] = ar2[ind2];
        ar2[ind2] = tmp;
    }

    static int impossibleIndex2() {
        return -2;
    }

    static int impossibleIndex3() {
        return -3;
    }

    static boolean isValidElement(int element) {
        return element >= 0;
    }

    private void ensureBufferBlocksCapacity(int blocks) {
        if (this.m_buffer.length < blocks) {
            int[][] newBuffer = new int[blocks][];
            for (int i = 0; i < this.m_buffer.length; ++i) {
                newBuffer[i] = this.m_buffer[i];
            }
            this.m_buffer = newBuffer;
        }
    }

    private void grow_(long newsize) {
        if (this.m_buffer == null) {
            this.m_bufferSize = 0;
            this.m_buffer = new int[8][];
        }
        assert (newsize > (long)this.m_capacity);
        long nblocks = (newsize + (long)this.m_blockSize - 1L) / (long)this.m_blockSize;
        if (nblocks > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureBufferBlocksCapacity((int)nblocks);
        if (nblocks == 1L) {
            int oldsz;
            int n = oldsz = this.m_capacity > 0 ? this.m_capacity : 0;
            assert ((long)oldsz < newsize);
            int i = 0;
            int realnewsize = (int)newsize * this.m_realStride;
            while (realnewsize > st_sizes[i]) {
                ++i;
            }
            int[] b = new int[st_sizes[i]];
            if (this.m_bufferSize == 1) {
                System.arraycopy(this.m_buffer[0], 0, b, 0, this.m_buffer[0].length);
                this.m_buffer[0] = b;
            } else {
                this.m_buffer[this.m_bufferSize] = b;
                ++this.m_bufferSize;
            }
            this.m_capacity = b.length / this.m_realStride;
        } else {
            if (nblocks * (long)this.m_blockSize > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            if (this.m_bufferSize == 1 && this.m_buffer[0].length < 16384) {
                int[] b = new int[16384];
                System.arraycopy(this.m_buffer[0], 0, b, 0, this.m_buffer[0].length);
                this.m_buffer[0] = b;
                this.m_capacity = this.m_blockSize;
            }
            while ((long)this.m_bufferSize < nblocks) {
                this.m_buffer[this.m_bufferSize++] = new int[16384];
                this.m_capacity += this.m_blockSize;
            }
        }
    }
}

