/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.data;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.internal.core.util.Strings;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class IdentifierIndex {
    private final Map<CqlIdentifier, Integer> byId;
    private final Map<String, Integer> byCaseSensitiveName;
    private final Map<String, Integer> byCaseInsensitiveName;

    public IdentifierIndex(List<CqlIdentifier> ids) {
        this.byId = Maps.newHashMapWithExpectedSize((int)ids.size());
        this.byCaseSensitiveName = Maps.newHashMapWithExpectedSize((int)ids.size());
        this.byCaseInsensitiveName = Maps.newHashMapWithExpectedSize((int)ids.size());
        int i = 0;
        for (CqlIdentifier id : ids) {
            this.byId.putIfAbsent(id, i);
            this.byCaseSensitiveName.putIfAbsent(id.asInternal(), i);
            this.byCaseInsensitiveName.putIfAbsent(id.asInternal().toLowerCase(), i);
            ++i;
        }
    }

    public int firstIndexOf(String name) {
        Integer index = Strings.isDoubleQuoted(name) ? this.byCaseSensitiveName.get(Strings.unDoubleQuote(name)) : this.byCaseInsensitiveName.get(name.toLowerCase());
        return index == null ? -1 : index;
    }

    public int firstIndexOf(CqlIdentifier id) {
        Integer index = this.byId.get(id);
        return index == null ? -1 : index;
    }
}

