/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareAsyncProcessor;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareSyncProcessor;
import com.datastax.oss.driver.internal.core.metrics.MetricUpdater;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.session.throttling.ConcurrencyLimitingRequestThrottler;
import com.datastax.oss.driver.internal.core.session.throttling.RateLimitingRequestThrottler;
import com.datastax.oss.driver.shaded.guava.common.cache.Cache;
import com.datastax.oss.driver.shaded.netty.util.Timeout;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricUpdater<MetricT>
implements MetricUpdater<MetricT> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMetricUpdater.class);
    public static Duration MIN_EXPIRE_AFTER = Duration.ofMinutes(5L);
    protected final InternalDriverContext context;
    protected final Set<MetricT> enabledMetrics;
    private final AtomicReference<Timeout> metricsExpirationTimeoutRef = new AtomicReference();
    private final Duration expireAfter;

    protected AbstractMetricUpdater(InternalDriverContext context, Set<MetricT> enabledMetrics) {
        this.context = context;
        this.enabledMetrics = enabledMetrics;
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        Duration expireAfter = config.getDuration(DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER);
        if (expireAfter.compareTo(MIN_EXPIRE_AFTER) < 0) {
            LOG.warn("[{}] Value too low for {}: {}. Forcing to {} instead.", new Object[]{context.getSessionName(), DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER.getPath(), expireAfter, MIN_EXPIRE_AFTER});
            expireAfter = MIN_EXPIRE_AFTER;
        }
        this.expireAfter = expireAfter;
    }

    @Override
    public boolean isEnabled(MetricT metric, String profileName) {
        return this.enabledMetrics.contains(metric);
    }

    public Duration getExpireAfter() {
        return this.expireAfter;
    }

    protected int connectedNodes() {
        int count = 0;
        for (Node node : this.context.getMetadataManager().getMetadata().getNodes().values()) {
            if (node.getOpenConnections() <= 0) continue;
            ++count;
        }
        return count;
    }

    protected int throttlingQueueSize() {
        RequestThrottler requestThrottler = this.context.getRequestThrottler();
        if (requestThrottler instanceof ConcurrencyLimitingRequestThrottler) {
            return ((ConcurrencyLimitingRequestThrottler)requestThrottler).getQueueSize();
        }
        if (requestThrottler instanceof RateLimitingRequestThrottler) {
            return ((RateLimitingRequestThrottler)requestThrottler).getQueueSize();
        }
        LOG.warn("[{}] Metric {} does not support {}, it will always return 0", new Object[]{this.context.getSessionName(), DefaultSessionMetric.THROTTLING_QUEUE_SIZE.getPath(), requestThrottler.getClass().getName()});
        return 0;
    }

    protected long preparedStatementCacheSize() {
        Cache<?, ?> cache = this.getPreparedStatementCache();
        if (cache == null) {
            LOG.warn("[{}] Metric {} is enabled in the config, but it looks like no CQL prepare processor is registered. The gauge will always return 0", (Object)this.context.getSessionName(), (Object)DefaultSessionMetric.CQL_PREPARED_CACHE_SIZE.getPath());
            return 0L;
        }
        return cache.size();
    }

    @Nullable
    protected Cache<?, ?> getPreparedStatementCache() {
        for (RequestProcessor<?, ?> processor : this.context.getRequestProcessorRegistry().getProcessors()) {
            if (processor instanceof CqlPrepareAsyncProcessor) {
                return ((CqlPrepareAsyncProcessor)processor).getCache();
            }
            if (!(processor instanceof CqlPrepareSyncProcessor)) continue;
            return ((CqlPrepareSyncProcessor)processor).getCache();
        }
        return null;
    }

    protected int availableStreamIds(Node node) {
        ChannelPool pool = this.context.getPoolManager().getPools().get(node);
        return pool == null ? 0 : pool.getAvailableIds();
    }

    protected int inFlightRequests(Node node) {
        ChannelPool pool = this.context.getPoolManager().getPools().get(node);
        return pool == null ? 0 : pool.getInFlight();
    }

    protected int orphanedStreamIds(Node node) {
        ChannelPool pool = this.context.getPoolManager().getPools().get(node);
        return pool == null ? 0 : pool.getOrphanedIds();
    }

    protected void startMetricsExpirationTimeout() {
        this.metricsExpirationTimeoutRef.accumulateAndGet(this.newTimeout(), (current, update) -> {
            if (current == null) {
                return update;
            }
            update.cancel();
            return current;
        });
    }

    protected void cancelMetricsExpirationTimeout() {
        Timeout t = this.metricsExpirationTimeoutRef.getAndSet(null);
        if (t != null) {
            t.cancel();
        }
    }

    protected Timeout newTimeout() {
        return this.context.getNettyOptions().getTimer().newTimeout(t -> {
            this.clearMetrics();
            this.cancelMetricsExpirationTimeout();
        }, this.expireAfter.toNanos(), TimeUnit.NANOSECONDS);
    }
}

