/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.DistanceEvent;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.util.concurrent.ReplayingEventFilter;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LoadBalancingPolicyWrapper
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(LoadBalancingPolicyWrapper.class);
    private final InternalDriverContext context;
    private final Set<LoadBalancingPolicy> policies;
    private final Map<String, LoadBalancingPolicy> policiesPerProfile;
    private final Map<LoadBalancingPolicy, SinglePolicyDistanceReporter> reporters;
    private final Lock distancesLock = new ReentrantLock();
    @GuardedBy(value="distancesLock")
    private final Map<Node, Map<LoadBalancingPolicy, NodeDistance>> distances;
    private final String logPrefix;
    private final ReplayingEventFilter<NodeStateEvent> eventFilter = new ReplayingEventFilter<NodeStateEvent>(this::processNodeStateEvent);
    private final AtomicReference<State> stateRef = new AtomicReference<State>(State.BEFORE_INIT);

    public LoadBalancingPolicyWrapper(@NonNull InternalDriverContext context, @NonNull Map<String, LoadBalancingPolicy> policiesPerProfile) {
        this.context = context;
        this.policiesPerProfile = policiesPerProfile;
        ImmutableMap.Builder reportersBuilder = ImmutableMap.builder();
        for (LoadBalancingPolicy policy : ImmutableSet.copyOf(policiesPerProfile.values())) {
            reportersBuilder.put((Object)policy, (Object)new SinglePolicyDistanceReporter(policy));
        }
        this.reporters = reportersBuilder.build();
        this.policies = this.reporters.keySet();
        this.distances = new WeakHashMap<Node, Map<LoadBalancingPolicy, NodeDistance>>();
        this.logPrefix = context.getSessionName();
        context.getEventBus().register(NodeStateEvent.class, this::onNodeStateEvent);
    }

    public void init() {
        if (this.stateRef.compareAndSet(State.BEFORE_INIT, State.DURING_INIT)) {
            LOG.debug("[{}] Initializing policies", (Object)this.logPrefix);
            this.eventFilter.start();
            MetadataManager metadataManager = this.context.getMetadataManager();
            Metadata metadata = metadataManager.getMetadata();
            for (LoadBalancingPolicy policy : this.policies) {
                policy.init(metadata.getNodes(), this.reporters.get(policy));
            }
            if (this.stateRef.compareAndSet(State.DURING_INIT, State.RUNNING)) {
                this.eventFilter.markReady();
            } else {
                assert (this.stateRef.get() == State.CLOSING);
                for (LoadBalancingPolicy policy : this.policies) {
                    policy.close();
                }
            }
        }
    }

    @NonNull
    public Queue<Node> newQueryPlan(@Nullable Request request, @NonNull String executionProfileName, @Nullable Session session) {
        switch (this.stateRef.get()) {
            case BEFORE_INIT: 
            case DURING_INIT: {
                ArrayList<DefaultNode> nodes = new ArrayList<DefaultNode>(this.context.getMetadataManager().getContactPoints());
                Collections.shuffle(nodes);
                return new ConcurrentLinkedQueue<Node>(nodes);
            }
            case RUNNING: {
                LoadBalancingPolicy policy = this.policiesPerProfile.get(executionProfileName);
                if (policy == null) {
                    policy = this.policiesPerProfile.get("default");
                }
                return policy.newQueryPlan(request, session);
            }
        }
        return new ConcurrentLinkedQueue<Node>();
    }

    @NonNull
    public Queue<Node> newControlReconnectionQueryPlan() {
        Queue<Node> regularQueryPlan = this.newQueryPlan(null, "default", null);
        if (!regularQueryPlan.isEmpty()) {
            return regularQueryPlan;
        }
        if (this.context.getConfig().getDefaultProfile().getBoolean(DefaultDriverOption.CONTROL_CONNECTION_RECONNECT_CONTACT_POINTS)) {
            Set<DefaultNode> originalNodes = this.context.getMetadataManager().getContactPoints();
            ArrayList<DefaultNode> nodes = new ArrayList<DefaultNode>();
            for (DefaultNode node : originalNodes) {
                nodes.add(new DefaultNode(node.getEndPoint(), this.context));
            }
            Collections.shuffle(nodes);
            return new ConcurrentLinkedQueue<Node>(nodes);
        }
        return regularQueryPlan;
    }

    private void onNodeStateEvent(NodeStateEvent event) {
        this.eventFilter.accept(event);
    }

    private void processNodeStateEvent(NodeStateEvent event) {
        DefaultNode node = event.node;
        switch (this.stateRef.get()) {
            case BEFORE_INIT: 
            case DURING_INIT: {
                throw new AssertionError((Object)"Filter should not be marked ready until LBP init");
            }
            case CLOSING: {
                return;
            }
            case RUNNING: {
                for (LoadBalancingPolicy policy : this.policies) {
                    if (event.newState == NodeState.UP) {
                        policy.onUp(node);
                        continue;
                    }
                    if (event.newState == NodeState.DOWN || event.newState == NodeState.FORCED_DOWN) {
                        policy.onDown(node);
                        continue;
                    }
                    if (event.newState == NodeState.UNKNOWN) {
                        policy.onAdd(node);
                        continue;
                    }
                    if (event.newState == null) {
                        policy.onRemove(node);
                        continue;
                    }
                    LOG.warn("[{}] Unsupported event: {}", (Object)this.logPrefix, (Object)event);
                }
                break;
            }
        }
    }

    @Override
    public void close() {
        State old;
        do {
            if ((old = this.stateRef.get()) != State.CLOSING) continue;
            return;
        } while (!this.stateRef.compareAndSet(old, State.CLOSING));
        if (old == State.RUNNING) {
            for (LoadBalancingPolicy policy : this.policies) {
                policy.close();
            }
        }
    }

    private class SinglePolicyDistanceReporter
    implements LoadBalancingPolicy.DistanceReporter {
        private final LoadBalancingPolicy policy;

        private SinglePolicyDistanceReporter(LoadBalancingPolicy policy) {
            this.policy = policy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDistance(@NonNull Node node, @NonNull NodeDistance suggestedDistance) {
            LOG.debug("[{}] {} suggested {} to {}, checking what other policies said", new Object[]{LoadBalancingPolicyWrapper.this.logPrefix, this.policy, node, suggestedDistance});
            LoadBalancingPolicyWrapper.this.distancesLock.lock();
            try {
                Map distancesForNode = LoadBalancingPolicyWrapper.this.distances.computeIfAbsent(node, n -> new HashMap());
                distancesForNode.put(this.policy, suggestedDistance);
                NodeDistance newDistance = this.aggregate(distancesForNode);
                LOG.debug("[{}] Shortest distance across all policies is {}", (Object)LoadBalancingPolicyWrapper.this.logPrefix, (Object)newDistance);
                NodeDistance oldDistance = node.getDistance();
                if (!oldDistance.equals((Object)newDistance)) {
                    LOG.debug("[{}] {} was {}, changing to {}", new Object[]{LoadBalancingPolicyWrapper.this.logPrefix, node, oldDistance, newDistance});
                    DefaultNode defaultNode = (DefaultNode)node;
                    defaultNode.distance = newDistance;
                    LoadBalancingPolicyWrapper.this.context.getEventBus().fire(new DistanceEvent(newDistance, defaultNode));
                } else {
                    LOG.debug("[{}] {} was already {}, ignoring", new Object[]{LoadBalancingPolicyWrapper.this.logPrefix, node, oldDistance});
                }
            }
            finally {
                LoadBalancingPolicyWrapper.this.distancesLock.unlock();
            }
        }

        private NodeDistance aggregate(Map<LoadBalancingPolicy, NodeDistance> distances) {
            NodeDistance minimum = NodeDistance.IGNORED;
            for (NodeDistance candidate : distances.values()) {
                if (candidate.compareTo(minimum) >= 0) continue;
                minimum = candidate;
            }
            return minimum;
        }
    }

    private static enum State {
        BEFORE_INIT,
        DURING_INIT,
        RUNNING,
        CLOSING;

    }
}

